/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.transceiver;

import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.transceiver.ATransceiver;
import bsc.sdk.api.transceiver.ChannelWorker;
import bsc.sdk.api.transceiver.ITransceiver;
import bsc.sdk.api.transceiver.state.ITransceiverState;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransceiverFactory {
    private static Logger logger = LoggerFactory.getLogger(TransceiverFactory.class);
    private static TransceiverFactory defaultFactory = null;

    public static TransceiverFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = TransceiverFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(TransceiverFactory factory) {
        defaultFactory = factory;
    }

    public static TransceiverFactory createDefaultFactory() {
        return new TransceiverFactory(){

            @Override
            public ITransceiver createInstance(ChannelWorker channel, Environment environment, ITransceiverState state) {
                ATransceiver transceiver = null;
                try {
                    transceiver = new ATransceiver(channel, environment, state);
                }
                catch (SocketException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                return transceiver;
            }
        };
    }

    public static ITransceiver createNewInstance(ChannelWorker channel, Environment environment, ITransceiverState state) {
        return TransceiverFactory.getDefaultFactory().createInstance(channel, environment, state);
    }

    public abstract ITransceiver createInstance(ChannelWorker var1, Environment var2, ITransceiverState var3);
}

