/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.transceiver;

import bsc.api.IApiObject;
import bsc.api.IIdentifiable;
import bsc.api.basic.commands.Command;
import bsc.api.transport.TransmissionObject;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.compression.ICompression;
import bsc.sdk.api.crypt.ICipher;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.exception.crypt.CipherException;
import bsc.sdk.api.protocol.IProtocol;
import bsc.sdk.api.transceiver.ChannelWorker;
import bsc.sdk.api.transceiver.listener.ITransceiverListener;
import bsc.sdk.api.transceiver.state.ITransceiverState;
import bsc.sdk.api.transceiver.transmission.manager.TransmissionIdentifier;
import bsc.sdk.api.user.session.manager.SessionIdentifier;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;

public interface ITransceiver
extends IIdentifiable {
    public void connect();

    public void disconnect(boolean var1);

    public TransmissionIdentifier write(TransmissionObject var1, ChannelWorker.WriteMode ... var2);

    public TransmissionIdentifier write(TransmissionObject var1, boolean var2, ChannelWorker.WriteMode ... var3);

    public void addTransceiverListener(ITransceiverListener var1);

    public boolean removeTransceiverListener(ITransceiverListener var1);

    public void fireStateChanged(TransceiverState var1);

    public void fireErrorOccured(TransceiverException var1);

    public void setCipher(ICipher var1);

    public ICipher getCipher();

    public void setCompression(ICompression var1);

    public ICompression getCompression();

    public void setProtocol(IProtocol var1);

    public IProtocol getProtocol();

    public Environment getEnvironment();

    public void setEnvironment(Environment var1);

    public TransmissionIdentifier sendCommand(Command var1);

    public TransmissionIdentifier sendObject(IApiObject var1);

    public TransmissionObject nextIncomingTransmission();

    public void closeChannel();

    public void error(TransceiverException var1);

    public void printStatistics();

    public long getInBytes();

    public long getOutBytes();

    public long getCreationTime();

    public void handleResult(TransmissionObject var1);

    public ExecutorService getExecutorService();

    public void exit();

    @Deprecated
    public void writeCustomHeader(byte[] var1);

    public ITransceiverState getTransceiverState();

    public void setTransceiverState(ITransceiverState var1);

    public String getTransceiverID();

    public void initialize(SessionIdentifier var1) throws CipherException;

    public void shutdownAfterSending(IApiObject var1);

    public ChannelWorker getChannelHandler();

    public InetSocketAddress getRemoteAddress();

    public boolean isAuthenticated();

    public TransceiverState getState();

    public static enum TransceiverState {
        CONNECTED,
        DISCONNECTED,
        READY;

    }
}

