/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.manager.impl;

import bsc.api.Enumerations;
import bsc.api.IIdentifiableApiObject;
import bsc.api.basic.container.ObjectContainer;
import bsc.api.basic.container.TYPE;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.metainfo.model.container.MetaInformationContainer;
import bsc.sdk.api.notification.objects.FullObjectContainerReceived;
import bsc.sdk.api.objects.manager.AObjectManager;
import bsc.sdk.api.objects.manager.DeviceIdentifier;
import bsc.sdk.api.objects.manager.ObjectIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ClientObjectManager
extends AObjectManager {
    private HashMap<String, HashMap<Integer, ObjectContainer>> incrementalContainers;

    @Override
    public boolean save() {
        return false;
    }

    @Override
    public boolean load() {
        return false;
    }

    @Override
    public boolean save(ObjectIdentifier identifier) {
        return false;
    }

    @Override
    protected void _shutdown() {
    }

    @Override
    protected IIdentifiableApiObject getNewObjectInstance(IIdentifiableApiObject orgObject) {
        return orgObject;
    }

    @Override
    protected void _init() {
        this.addObjectBusTag(Enumerations.OBJECT_BUS_TAGS.RECEIVED_OBJECT);
    }

    @Override
    public void objectReceived(String tag, Object object) {
        Enumerations.OBJECT_BUS_TAGS tagEnum = Enumerations.OBJECT_BUS_TAGS.valueOf(tag);
        if (tagEnum != null) {
            switch (tagEnum) {
                case RECEIVED_OBJECT: {
                    if (object instanceof IIdentifiableApiObject) {
                        this.updateObject((IIdentifiableApiObject)object);
                        break;
                    }
                    if (object instanceof ObjectContainer) {
                        this.handleContainer((ObjectContainer)object);
                        break;
                    }
                    if (!(object instanceof MetaInformationContainer)) break;
                    this.handleMetaInfoUpdate((MetaInformationContainer)object);
                    break;
                }
            }
        }
    }

    private void handleMetaInfoUpdate(MetaInformationContainer object) {
        DeviceIdentifier identifier = (DeviceIdentifier)this.getIdentifierInstance(DeviceIdentifier.generateURI(object.getMetaID(), this.getEnvironment()));
        if (identifier != null && identifier.objectExists()) {
            ADevice device = (ADevice)identifier.getObjectInstance();
            for (Map.Entry<String, String> metaInfo : object.getAllMetaInformations().entrySet()) {
                device.addMetaInformation(metaInfo.getKey(), metaInfo.getValue());
            }
            this.updateObject(device);
        }
    }

    private void handleContainer(ObjectContainer container) {
        if (container == null) {
            return;
        }
        TYPE containerType = container.getType();
        if (containerType == null) {
            return;
        }
        switch (containerType) {
            case FULL_INCREMENTAL: {
                String sequenceID = container.getSequenceId();
                if (!this.incrementalContainers.containsKey(sequenceID)) {
                    this.incrementalContainers.put(sequenceID, new HashMap());
                }
                HashMap<Integer, ObjectContainer> receivedSequences = this.incrementalContainers.get(sequenceID);
                receivedSequences.put(container.getSequenceCount(), container);
                if (receivedSequences.size() != container.getSequenceLength()) break;
                ArrayList<IIdentifiableApiObject> newObjects = new ArrayList<IIdentifiableApiObject>();
                Iterator<ObjectContainer> itr = receivedSequences.values().iterator();
                while (itr.hasNext()) {
                    newObjects.addAll(itr.next().getObjects());
                }
                ObjectContainer newContainer = new ObjectContainer(TYPE.FULL, (Collection<IIdentifiableApiObject>)newObjects);
                newContainer.setSequenceId(sequenceID);
                receivedSequences.clear();
                this.incrementalContainers.remove(sequenceID);
                this.handleContainer(newContainer);
                break;
            }
            case FULL: {
                this.clearObjectPool();
                this.addObject((Collection<IIdentifiableApiObject>)container.getObjects());
                this.fireNotification(new FullObjectContainerReceived());
                break;
            }
            case INCREMENTAL: {
                this.updateObject(container.getObjects());
            }
        }
    }

    @Override
    public IIdentifiableApiObject getObjectInstance(ObjectIdentifier objectIdentifier) {
        return super.getObjectInstance(objectIdentifier, false);
    }
}

