/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.manager;

import bsc.api.IIdentifiableApiObject;
import bsc.sdk.api.application.identifier.AIdentifier;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public class ObjectIdentifier
extends AIdentifier<IIdentifiableApiObject> {
    public static int OBJECT_TYPE_PART = 0;
    protected final OBJECT_TYPE objectType = OBJECT_TYPE.valueOf(this.getPathPart(OBJECT_TYPE_PART));

    public ObjectIdentifier(URI uri) throws URISyntaxException {
        super(uri);
    }

    public OBJECT_TYPE getObjectType() {
        return this.objectType;
    }

    @Override
    public IIdentifiableApiObject getObjectInstance() {
        return (IIdentifiableApiObject)this.environment.getObjectManager().getObjectInstance(this);
    }

    public IIdentifiableApiObject getUserObjectInstance(UserCredentialIdentifier user) {
        return this.environment.getObjectManager().getObjectFromUserCache(Objects.requireNonNull(user, "user must not be null!"), this);
    }

    @Override
    public boolean deleteObject() {
        return this.environment.getObjectManager().removeObject(this);
    }

    @Override
    public boolean updateObject(IIdentifiableApiObject objectInstance) {
        return this.environment.getObjectManager().updateObject(objectInstance);
    }

    @Override
    public boolean saveObject() {
        return this.environment.getObjectManager().save(this);
    }

    public void rebuildUserObjectCache() {
        this.environment.getObjectManager().rebuildUserObjectCache(this);
    }

    public void rebuildUserObjectCache(UserCredentialIdentifier user) {
        this.environment.getObjectManager().rebuildUserObjectCache(user, this);
    }

    public static enum OBJECT_TYPE {
        GROUP,
        DEVICE,
        SENSOR;

    }
}

