/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.manager;

import bsc.api.ApiObjectIdentifier;
import bsc.api.modules.core.model.Group;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.objects.manager.ObjectIdentifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public class GroupIdentifier
extends ObjectIdentifier {
    public static int GROUP_ID_PART = 1;
    private final String groupID = this.getPathPart(GROUP_ID_PART);

    public GroupIdentifier(URI uri) throws URISyntaxException {
        super(uri);
    }

    public String getGroupID() {
        return this.groupID;
    }

    public static URI generateURI(String groupID, String applicationID, String host) {
        return ApiObjectIdentifier.getGroupUri(groupID, applicationID, host);
    }

    public static URI generateURI(String groupID, Environment enviromentSettings) {
        return GroupIdentifier.generateURI(groupID, Objects.requireNonNull(enviromentSettings, "enviromentSettings must not be null!").getApplicationId(), enviromentSettings.getHostID());
    }

    public static GroupIdentifier createIdentifierInstance(String groupID, Environment environment) throws URISyntaxException {
        return new GroupIdentifier(GroupIdentifier.generateURI(groupID, environment));
    }

    public static GroupIdentifier createIdentifierInstance(Group group, Environment environment) throws URISyntaxException {
        return new GroupIdentifier(GroupIdentifier.generateURI(String.valueOf(Objects.requireNonNull(group, "group must not be null!").getId()), environment));
    }
}

