/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.manager;

import bsc.api.ApiObjectIdentifier;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ISensor;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.objects.manager.IObjectManager;
import bsc.sdk.api.objects.manager.ObjectIdentifier;
import bsc.sdk.api.objects.manager.SensorIdentifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class DeviceIdentifier
extends ObjectIdentifier {
    public static int DEVICE_ID_PART = 1;
    protected final String deviceID = this.getPathPart(DEVICE_ID_PART);

    public DeviceIdentifier(URI uri) throws URISyntaxException {
        super(uri);
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public Collection<SensorIdentifier> getSensorIdentifier() {
        IObjectManager objectManager = this.getEnvironment().getObjectManager();
        ArrayList<SensorIdentifier> identifier = new ArrayList<SensorIdentifier>();
        ADevice device = (ADevice)objectManager.getObjectInstance(this);
        List<ISensor> sensors = device.getSensors();
        if (sensors != null) {
            for (ISensor sensor : sensors) {
                identifier.add((SensorIdentifier)objectManager.getIdentifierInstance(sensor));
            }
        }
        return identifier;
    }

    public static URI generateURI(String deviceID, String applicationID, String host) {
        return ApiObjectIdentifier.getDeviceURI(deviceID, applicationID, host);
    }

    public static URI generateURI(String deviceID, Environment environment) {
        return DeviceIdentifier.generateURI(deviceID, Objects.requireNonNull(environment, "enviromentSettings must not be null!").getApplicationId(), environment.getHostID());
    }

    public static DeviceIdentifier createIdentifierInstance(String deviceID, Environment environment) throws URISyntaxException {
        return new DeviceIdentifier(DeviceIdentifier.generateURI(deviceID, environment));
    }

    public static DeviceIdentifier createIdentifierInstance(ADevice device, Environment environment) throws URISyntaxException {
        return new DeviceIdentifier(DeviceIdentifier.generateURI(Objects.requireNonNull(device, "userCredential must not be null!").getDeviceID(), environment));
    }
}

