/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.manager;

import bsc.api.IIdentifiableApiObject;
import bsc.api.IUpdateableObject;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.IExtendedEquals;
import bsc.api.basic.model.ISensor;
import bsc.api.modules.core.model.Group;
import bsc.sdk.api.AManager;
import bsc.sdk.api.application.identifier.AIdentifier;
import bsc.sdk.api.application.identifier.IIdentifier;
import bsc.sdk.api.notification.objects.ObjectStatus;
import bsc.sdk.api.objects.manager.DeviceIdentifier;
import bsc.sdk.api.objects.manager.GroupIdentifier;
import bsc.sdk.api.objects.manager.IObjectManager;
import bsc.sdk.api.objects.manager.ObjectIdentifier;
import bsc.sdk.api.objects.manager.SensorIdentifier;
import bsc.sdk.api.objects.manager.cache.IDeviceCacheProcessor;
import bsc.sdk.api.objects.manager.cache.IUserObjectCache;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import bsc.sdk.api.user.group.Permission;
import bsc.sdk.tools.Tools;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AObjectManager
extends AManager<ObjectIdentifier, IIdentifiableApiObject>
implements IObjectManager {
    protected IUserObjectCache userObjectCache;
    protected Map<Integer, Set<String>> groupMemberLookupCache = new ConcurrentHashMap<Integer, Set<String>>();

    @Override
    public void rebuildUserObjectCache() {
        this.rebuildUserObjectCache(null, null);
    }

    @Override
    public void rebuildUserObjectCache(UserCredentialIdentifier user) {
        if (this.userObjectCache == null) {
            return;
        }
        this.userObjectCache.clearUserCache(user);
        this.rebuildUserObjectCache(user, null);
    }

    @Override
    public void rebuildUserObjectCache(ObjectIdentifier object) {
        this.rebuildUserObjectCache(null, object);
    }

    @Override
    public void rebuildUserObjectCache(UserCredentialIdentifier user, ObjectIdentifier object) {
        this._rebuildUserObjectCache(user, object);
    }

    protected void _rebuildUserObjectCache(UserCredentialIdentifier user, ObjectIdentifier object) {
        if (this.userObjectCache == null) {
            return;
        }
        if (user == null) {
            Iterator<UserCredentialIdentifier> itr = this.environment.getUserCredentialManager().getUserCredentialList().iterator();
            while (itr.hasNext()) {
                this._rebuildUserObjectCache(itr.next(), object);
            }
        } else if (object == null) {
            for (ObjectIdentifier identifier : this.identifierCache.values()) {
                if (identifier.getObjectType().equals((Object)ObjectIdentifier.OBJECT_TYPE.SENSOR)) continue;
                this.userObjectCache.refreshObject(user, identifier);
            }
        } else {
            this.userObjectCache.refreshObject(user, object);
        }
    }

    @Override
    public ObjectIdentifier addObject(IIdentifiableApiObject object) {
        return this.addObject(object, true);
    }

    @Override
    public Collection<ObjectIdentifier> addObject(Collection<IIdentifiableApiObject> object, boolean rebuildPermissionCache) {
        HashSet<ObjectIdentifier> result = new HashSet<ObjectIdentifier>();
        for (IIdentifiableApiObject iIdentifiableApiObject : object) {
            result.add(this.addObject(iIdentifiableApiObject, rebuildPermissionCache));
        }
        return result;
    }

    @Override
    public ObjectIdentifier addObject(IIdentifiableApiObject object, boolean rebuildPermissionCache) {
        return this.addObject(object, rebuildPermissionCache, false);
    }

    public ObjectIdentifier addObject(IIdentifiableApiObject object, boolean rebuildPermissionCache, boolean silent) {
        if (object == null) {
            return null;
        }
        this.cacheCleanerActive = false;
        ObjectIdentifier identifier = (ObjectIdentifier)this.getIdentifierInstance(object);
        if (identifier == null) {
            return identifier;
        }
        if (this.objects.containsKey(identifier.getFullQualifiedIdentifiableString())) {
            this.updateObject(object);
        } else {
            this.logger.trace("ADD OBJECT: " + identifier.getFullQualifiedIdentifiableString());
            this.objects.put(identifier.getFullQualifiedIdentifiableString(), object);
            this.cacheCleanerActive = true;
            if (rebuildPermissionCache) {
                this.rebuildUserObjectCache(identifier);
            }
            if (!silent) {
                this.fireNotification(new ObjectStatus(identifier, ObjectStatus.STATUS.ADDED));
            }
            if (object instanceof ADevice) {
                ADevice device = (ADevice)object;
                this.addDeviceGroupCacheEntry(device);
            }
        }
        return identifier;
    }

    @Override
    public boolean isUserObjectCacheRebuildInProgress() {
        if (this.userObjectCache != null) {
            return this.userObjectCache.isRebuildInProgress();
        }
        return false;
    }

    @Override
    public int getUserObjectCacheRebuildCount() {
        if (this.userObjectCache != null) {
            return this.userObjectCache.getCurrentWorkerCount();
        }
        return 0;
    }

    @Deprecated
    protected Collection<ObjectIdentifier> addDeviceSensors(ADevice device, boolean silent) {
        HashSet<ObjectIdentifier> result = new HashSet<ObjectIdentifier>();
        for (ISensor sensor : device.getSensors()) {
            result.add(this.addObject(sensor, true, true));
        }
        return result;
    }

    @Override
    public boolean removeObject(ObjectIdentifier objectIdentifier) {
        return this.removeObject(objectIdentifier, false);
    }

    protected boolean removeObject(ObjectIdentifier objectIdentifier, boolean silent) {
        ADevice device;
        if (objectIdentifier.getObjectType().equals((Object)ObjectIdentifier.OBJECT_TYPE.DEVICE) && (device = (ADevice)this.objects.get(objectIdentifier.getFullQualifiedIdentifiableString())) != null) {
            for (Integer grpID : device.getGrpIDs()) {
                Set<String> grpCache = this.groupMemberLookupCache.get(grpID);
                if (grpCache == null) {
                    grpCache = Collections.newSetFromMap(new ConcurrentHashMap());
                    this.groupMemberLookupCache.put(grpID, grpCache);
                }
                grpCache.remove(objectIdentifier.getFullQualifiedIdentifiableString());
                if (!grpCache.isEmpty()) continue;
                this.groupMemberLookupCache.remove(grpID);
            }
        }
        if (!silent) {
            this.fireNotification(new ObjectStatus(objectIdentifier, ObjectStatus.STATUS.DELETED));
            this.logger.trace("REMOVE OBJECT: " + objectIdentifier.getFullQualifiedIdentifiableString());
        }
        if (this.userObjectCache != null) {
            this.userObjectCache.removeObject(objectIdentifier);
        }
        return this.objects.remove(objectIdentifier.getFullQualifiedIdentifiableString()) != null;
    }

    protected boolean updateObject(Collection<IIdentifiableApiObject> objects) {
        boolean result = true;
        for (IUpdateableObject iUpdateableObject : objects) {
            result &= this.updateObject(iUpdateableObject);
        }
        return result;
    }

    @Override
    public boolean updateObject(IUpdateableObject object) {
        boolean result = false;
        if (object == null || !(object instanceof IIdentifiableApiObject)) {
            return result;
        }
        IIdentifiableApiObject apiObject = (IIdentifiableApiObject)object;
        ObjectIdentifier identifier = (ObjectIdentifier)this.getIdentifierInstance(apiObject);
        if (!identifier.objectExists()) {
            this.addObject(apiObject);
        } else {
            IIdentifiableApiObject orgObj = this.getObjectInstance(identifier, false);
            if (orgObj != null && orgObj instanceof IUpdateableObject) {
                boolean sameObjectInstance = false;
                if (orgObj instanceof IExtendedEquals) {
                    IExtendedEquals extEQ = (IExtendedEquals)((Object)orgObj);
                    sameObjectInstance = extEQ.equals(object, false);
                }
                boolean isADevice = orgObj instanceof ADevice;
                this.logger.trace("UPDATE OBJECT: " + identifier.getFullQualifiedIdentifiableString());
                if (isADevice) {
                    DeviceIdentifier devIdent = (DeviceIdentifier)identifier;
                    this.removeDeviceGroupCacheEntry(devIdent);
                }
                if (!sameObjectInstance) {
                    try {
                        IIdentifiableApiObject updateableObject = orgObj;
                        result = updateableObject.updateObject(object);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        result = false;
                    }
                }
                if (isADevice) {
                    ADevice device = (ADevice)orgObj;
                    this.addDeviceGroupCacheEntry(device);
                }
                this.fireNotification(new ObjectStatus(identifier, ObjectStatus.STATUS.CHANGED));
                this.rebuildUserObjectCache(identifier);
            }
        }
        return result;
    }

    private void removeDeviceGroupCacheEntry(DeviceIdentifier identifier) {
        String identifierString = identifier.getFullQualifiedIdentifiableString();
        for (Set<String> set : this.groupMemberLookupCache.values()) {
            set.remove(identifierString);
        }
    }

    private void addDeviceGroupCacheEntry(ADevice device) {
        ObjectIdentifier identifier = (ObjectIdentifier)this.getIdentifierInstance(device);
        if (device.getGrpIDs().isEmpty()) {
            Set<String> grpCache = this.groupMemberLookupCache.get(0);
            if (grpCache == null) {
                grpCache = Collections.newSetFromMap(new ConcurrentHashMap());
                this.groupMemberLookupCache.put(0, grpCache);
            }
            grpCache.add(identifier.getFullQualifiedIdentifiableString());
        } else {
            for (Integer grpID : device.getGrpIDs()) {
                Set<String> grpCache = this.groupMemberLookupCache.get(grpID);
                if (grpCache == null) {
                    grpCache = Collections.newSetFromMap(new ConcurrentHashMap());
                    this.groupMemberLookupCache.put(grpID, grpCache);
                }
                grpCache.add(identifier.getFullQualifiedIdentifiableString());
            }
        }
    }

    @Override
    public IIdentifiableApiObject getObjectFromUserCache(UserCredentialIdentifier user, ObjectIdentifier object) {
        if (this.userObjectCache == null) {
            return null;
        }
        this.userObjectCache.waitForCacheRebuild(Objects.requireNonNull(user, "user must not be null!"), Objects.requireNonNull(object, "object must not be null!"));
        return this.getNewObjectInstance(this.userObjectCache.getObjectFromCache(user, object));
    }

    @Override
    public Set<ObjectIdentifier> getObjectsByType(EnumSet<ObjectIdentifier.OBJECT_TYPE> types) {
        HashSet<ObjectIdentifier> result = new HashSet<ObjectIdentifier>();
        if (types != null) {
            for (ObjectIdentifier identifier : this.identifierCache.values()) {
                if (!types.contains((Object)identifier.getObjectType())) continue;
                result.add(identifier);
            }
        }
        return result;
    }

    @Override
    public Set<IIdentifiableApiObject> getAllObjectsForUser(UserCredentialIdentifier user) {
        return this.getAllObjectsForUser(user, true, true);
    }

    @Override
    public Set<IIdentifiableApiObject> getAllObjectsForUser(UserCredentialIdentifier user, boolean ignoreSensors, boolean waitForCacheRebuild) {
        EnumSet<ObjectIdentifier.OBJECT_TYPE> types = EnumSet.allOf(ObjectIdentifier.OBJECT_TYPE.class);
        if (ignoreSensors) {
            types.remove((Object)ObjectIdentifier.OBJECT_TYPE.SENSOR);
        }
        return this.getObjectsForUser(user, types, waitForCacheRebuild);
    }

    @Override
    public EnumSet<Permission> getUserPermissions(UserCredentialIdentifier userIdentifier, IIdentifiableApiObject iIdentifiableApiObject) {
        return this.getUserPermissionFromCache(userIdentifier, iIdentifiableApiObject);
    }

    @Override
    public EnumSet<Permission> getUserPermissions(UserCredentialIdentifier userIdentifier, ObjectIdentifier objectIdentifier) {
        return this.getUserPermissionFromCache(userIdentifier, objectIdentifier);
    }

    protected EnumSet<Permission> getUserPermissionFromCache(UserCredentialIdentifier user, IIdentifiableApiObject object) {
        return this.getUserPermissionFromCache(user, (ObjectIdentifier)this.getIdentifierInstance(object));
    }

    protected EnumSet<Permission> getUserPermissionFromCache(UserCredentialIdentifier user, ObjectIdentifier object) {
        if (this.userObjectCache == null) {
            return EnumSet.noneOf(Permission.class);
        }
        return this.userObjectCache.getUserPermissionFromCache(user, object);
    }

    private <T extends IIdentifiableApiObject> Set<T> getAllObjects(Class<T> objectClass, ObjectIdentifier.OBJECT_TYPE objectType) {
        HashSet<IIdentifiableApiObject> result = new HashSet<IIdentifiableApiObject>();
        for (ObjectIdentifier identifier : this.identifierCache.values()) {
            IIdentifiableApiObject obj;
            if (!identifier.getObjectType().equals((Object)objectType) || (obj = identifier.getObjectInstance()) == null) continue;
            try {
                result.add(obj);
            }
            catch (ClassCastException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public Set<ADevice> getAllDevices() {
        return this.getAllObjects(ADevice.class, ObjectIdentifier.OBJECT_TYPE.DEVICE);
    }

    @Override
    public Set<Group> getAllGroups() {
        return this.getAllObjects(Group.class, ObjectIdentifier.OBJECT_TYPE.GROUP);
    }

    @Override
    public Set<ISensor> getAllSensors() {
        HashSet<ISensor> result = new HashSet<ISensor>();
        for (ADevice device : this.getAllDevices()) {
            result.addAll(device.getSensors());
        }
        return result;
    }

    @Override
    public Collection<ObjectIdentifier> addObject(Collection<IIdentifiableApiObject> object) {
        HashSet<ObjectIdentifier> result = new HashSet<ObjectIdentifier>();
        for (IIdentifiableApiObject iIdentifiableApiObject : object) {
            result.add(this.addObject(iIdentifiableApiObject));
        }
        return result;
    }

    @Override
    protected <N extends IIdentifier<IIdentifiableApiObject>> N getIdentifierInstance(Class<N> clazz, URI uri) {
        switch (this.getObjectTypeFromURI(uri)) {
            case DEVICE: {
                return (N)super.getIdentifierInstance(DeviceIdentifier.class, uri);
            }
            case GROUP: {
                return (N)super.getIdentifierInstance(GroupIdentifier.class, uri);
            }
            case SENSOR: {
                return (N)super.getIdentifierInstance(SensorIdentifier.class, uri);
            }
        }
        return super.getIdentifierInstance(clazz, uri);
    }

    private ObjectIdentifier.OBJECT_TYPE getObjectTypeFromURI(URI uri) {
        return ObjectIdentifier.OBJECT_TYPE.valueOf(AIdentifier.getPathPart(ObjectIdentifier.OBJECT_TYPE_PART, uri));
    }

    protected Set<ObjectIdentifier> getAllIdentifiers() {
        return new HashSet<ObjectIdentifier>(this.identifierCache.values());
    }

    @Override
    public void waitForUserObjectCacheRebuild(UserCredentialIdentifier user) {
        if (this.userObjectCache != null) {
            this.userObjectCache.waitForCacheRebuild(user);
        }
    }

    @Override
    public boolean clearObjectPool() {
        for (ObjectIdentifier identifier : this.getAllIdentifiers()) {
            identifier.deleteObject();
        }
        return this.objects.isEmpty();
    }

    @Override
    public Set<IIdentifiableApiObject> getObjectsForUser(UserCredentialIdentifier user, EnumSet<ObjectIdentifier.OBJECT_TYPE> types) {
        return this.getObjectsForUser(user, types, true);
    }

    @Override
    public Set<IIdentifiableApiObject> getObjectsForUser(UserCredentialIdentifier user, EnumSet<ObjectIdentifier.OBJECT_TYPE> types, boolean waitForCacheRebuild) {
        long start = System.currentTimeMillis();
        this.logger.trace("Start to collect objects...");
        HashSet<IIdentifiableApiObject> result = new HashSet<IIdentifiableApiObject>();
        boolean cacheExists = this.userObjectCache != null;
        this.logger.trace("Use user object cache: " + cacheExists);
        if (cacheExists) {
            if (waitForCacheRebuild) {
                this.userObjectCache.waitForCacheRebuild(user);
            }
            Map<String, IIdentifiableApiObject> typedCache = this.userObjectCache.getUserObjectCacheByType(user, types);
            result.addAll(typedCache.values());
        } else {
            for (ObjectIdentifier identifier : this.getObjectsByType(types)) {
                IIdentifiableApiObject obj = identifier.getObjectInstance();
                if (obj == null) continue;
                result.add(obj);
            }
        }
        this.logger.trace(result.size() + " objects collected. Takes: " + (System.currentTimeMillis() - start) + "ms");
        return result;
    }

    public Set<ADevice> getUserDevicesForGroupID(UserCredentialIdentifier user, int groupID) {
        HashSet<ADevice> result = new HashSet<ADevice>();
        Set<String> set = this.groupMemberLookupCache.get(groupID);
        if (set != null) {
            ObjectIdentifier[] objects = new ObjectIdentifier[set.size()];
            int count = 0;
            for (String identifierString : set) {
                objects[count] = (ObjectIdentifier)this.getIdentifierInstance(identifierString, false);
                ++count;
            }
            for (IIdentifiableApiObject obj : this.userObjectCache.getObjectFromCache(user, objects)) {
                try {
                    result.add((ADevice)obj);
                }
                catch (ClassCastException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    @Override
    public IIdentifiableApiObject getObjectInstance(ObjectIdentifier objectIdentifier) {
        return this.getObjectInstance(objectIdentifier, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IIdentifiableApiObject getObjectInstance(ObjectIdentifier objectIdentifier, boolean createNewInstance) {
        IIdentifiableApiObject result = null;
        if (objectIdentifier == null) {
            return result;
        }
        if (objectIdentifier.getObjectType().equals((Object)ObjectIdentifier.OBJECT_TYPE.SENSOR)) {
            SensorIdentifier sensor = (SensorIdentifier)objectIdentifier;
            ADevice device = (ADevice)this.getObjectInstance(sensor.getDeviceIdentifier(), false);
            if (device != null) {
                result = device.getSensorByID(sensor.getSensorID());
            }
        } else {
            result = (IIdentifiableApiObject)super.getObjectInstance(objectIdentifier);
        }
        if (createNewInstance && result != null) {
            IIdentifiableApiObject iIdentifiableApiObject = result;
            synchronized (iIdentifiableApiObject) {
                result = Tools.deepClone(result);
            }
        }
        return result;
    }

    @Override
    public void registerDeviceCacheProcessor(IDeviceCacheProcessor processor) {
        this.userObjectCache.registerDeviceCacheProcessor(processor);
    }

    @Override
    public void unregisterDeviceCacheProcessor(IDeviceCacheProcessor processor) {
        this.userObjectCache.unregisterDeviceCacheProcessor(processor);
    }
}

