/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.weatherstation.configuration;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.sensor.SunIntensitySensor;
import bsc.api.modules.core.model.sensor.state.DayNightSensor;
import bsc.api.modules.core.model.sensor.state.DetectionSensor;
import bsc.sdk.api.objects.device.type.AValueDeviceConfiguration;
import bsc.sdk.api.objects.device.type.ValueSettings;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WeatherstationEltakoConfiguration
extends AValueDeviceConfiguration {
    private final String brightnessSensorId;
    private final String windSpeedSensorId;
    private final String dayNightSensorId;
    private final String rainSensorId;
    private final String sunIntensitySensorId;
    private ValueSettings brightnessValueSettings;
    private ValueSettings windSpeedValueSettings;
    private DayNightSensor.State dayNightCurrentState;
    private DetectionSensor.State rainCurrentState;
    private Map<DIRECTION, ValueSettings> sunIntensityValueSettings;
    private SunIntensitySensor.Hemisphere sunIntensityValueSettingsHemisphere = SunIntensitySensor.Hemisphere.NORTH;

    public WeatherstationEltakoConfiguration(String deviceId, String sensorId, String brightnessSensorId, String windSpeedSensorId, String dayNightSensorId, String rainSensorId, String sunIntensitySensorId, ADevice.DeviceState state, String name, List<Integer> grpIDs, ValueSettings valueSettings, ValueSettings brightnessValueSettings, ValueSettings windSpeedValueSettings, DayNightSensor.State dayNightCurrentState, DetectionSensor.State rainCurrentState, Map<DIRECTION, ValueSettings> sunIntensityValueSettings) {
        this(Enumerations.DeviceType.WeatherstationEltako, deviceId, sensorId, brightnessSensorId, windSpeedSensorId, dayNightSensorId, rainSensorId, sunIntensitySensorId, state, name, grpIDs, valueSettings, brightnessValueSettings, windSpeedValueSettings, dayNightCurrentState, rainCurrentState, sunIntensityValueSettings);
    }

    protected WeatherstationEltakoConfiguration(Enumerations.DeviceType deviceType, String deviceId, String sensorId, String brightnessSensorId, String windSpeedSensorId, String dayNightSensorId, String rainSensorId, String sunIntensitySensorId, ADevice.DeviceState state, String name, List<Integer> grpIDs, ValueSettings valueSettings, ValueSettings brightnessValueSettings, ValueSettings windSpeedValueSettings, DayNightSensor.State dayNightCurrentState, DetectionSensor.State rainCurrentState, Map<DIRECTION, ValueSettings> sunIntensityValueSettings) {
        super(deviceType, deviceId, sensorId, state, name, grpIDs, valueSettings);
        this.brightnessSensorId = Objects.requireNonNull(brightnessSensorId, "brightnessSensorId must not be null!");
        this.windSpeedSensorId = Objects.requireNonNull(windSpeedSensorId, "windSpeedSensorId must not be null!");
        this.dayNightSensorId = Objects.requireNonNull(dayNightSensorId, "dayNightSensorId must not be null!");
        this.rainSensorId = Objects.requireNonNull(rainSensorId, "rainSensorId must not be null!");
        this.sunIntensitySensorId = Objects.requireNonNull(sunIntensitySensorId, "sunIntensitySensorId must not be null!");
        this.brightnessValueSettings = Objects.requireNonNull(brightnessValueSettings, "brightnessValueSettings must not be null!");
        this.windSpeedValueSettings = Objects.requireNonNull(windSpeedValueSettings, "windSpeedValueSettings must not be null!");
        this.dayNightCurrentState = Objects.requireNonNull(dayNightCurrentState, "dayNightCurrentState must not be null!");
        this.rainCurrentState = Objects.requireNonNull(rainCurrentState, "rainCurrentState must not be null!");
        this.sunIntensityValueSettings = Objects.requireNonNull(sunIntensityValueSettings, "sunIntensitySensorId must not be null!");
    }

    public ValueSettings getBrightnessValueSettings() {
        return this.brightnessValueSettings;
    }

    public void setBrightnessValueSettings(ValueSettings brightnessValueSettings) {
        this.brightnessValueSettings = brightnessValueSettings;
    }

    public ValueSettings getWindSpeedValueSettings() {
        return this.windSpeedValueSettings;
    }

    public void setWindSpeedValueSettings(ValueSettings windSpeedValueSettings) {
        this.windSpeedValueSettings = windSpeedValueSettings;
    }

    public Map<DIRECTION, ValueSettings> getSunIntensityValueSettings() {
        return this.sunIntensityValueSettings;
    }

    public void setSunIntensityValueSettings(Map<DIRECTION, ValueSettings> sunIntensityValueSettings) {
        this.sunIntensityValueSettings = sunIntensityValueSettings;
    }

    public String getBrightnessSensorId() {
        return this.brightnessSensorId;
    }

    public String getWindSpeedSensorId() {
        return this.windSpeedSensorId;
    }

    public String getDayNightSensorId() {
        return this.dayNightSensorId;
    }

    public String getRainSensorId() {
        return this.rainSensorId;
    }

    public String getSunIntensitySensorId() {
        return this.sunIntensitySensorId;
    }

    public DayNightSensor.State getDayNightCurrentState() {
        return this.dayNightCurrentState;
    }

    public void setDayNightCurrentState(DayNightSensor.State dayNightCurrentState) {
        this.dayNightCurrentState = dayNightCurrentState;
    }

    public DetectionSensor.State getRainCurrentState() {
        return this.rainCurrentState;
    }

    public void setRainCurrentState(DetectionSensor.State rainCurrentState) {
        this.rainCurrentState = rainCurrentState;
    }

    @Override
    public String toString() {
        return "WeatherstationEltakoConfiguration [brightnessSensorId=" + this.brightnessSensorId + ", windSpeedSensorId=" + this.windSpeedSensorId + ", dayNightSensorId=" + this.dayNightSensorId + ", rainSensorId=" + this.rainSensorId + ", sunIntensitySensorId=" + this.sunIntensitySensorId + ", brightnessValueSettings=" + this.brightnessValueSettings + ", windSpeedValueSettings=" + this.windSpeedValueSettings + ", dayNightCurrentState=" + (Object)((Object)this.dayNightCurrentState) + ", rainCurrentState=" + (Object)((Object)this.rainCurrentState) + ", sunIntensityValueSettings=" + this.sunIntensityValueSettings + ", toString()=" + super.toString() + "]";
    }

    public SunIntensitySensor.Hemisphere getSunIntensityValueSettingsHemisphere() {
        return this.sunIntensityValueSettingsHemisphere;
    }

    public void setSunIntensityValueSettingsHemisphere(SunIntensitySensor.Hemisphere sunIntensityValueSettingsHemisphere) {
        this.sunIntensityValueSettingsHemisphere = sunIntensityValueSettingsHemisphere;
    }

    public static enum DIRECTION {
        NORTH,
        SOUTH,
        WEST,
        EAST;

    }
}

