/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.jalousie;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.AValueSensor;
import bsc.api.modules.core.model.sensor.state.UpSensorSlat;
import bsc.api.modules.core.model.sensor.state.enabled.SlowlyDriveEnabledSensor;
import bsc.api.modules.core.model.sensor.state.enabled.TurnAutomaticEnabledSensor;
import bsc.api.modules.core.model.sensor.state.on.PrioritySensor;
import bsc.api.modules.core.model.sensor.state.up.Jalousie;
import bsc.api.modules.core.model.sensor.state.up.JalousieSlat;
import bsc.api.modules.core.model.sensor.value.JalousieInvertedSensor;
import bsc.api.modules.core.model.sensor.value.JalousieSensor;
import bsc.api.modules.core.model.sensor.value.ValueSensor;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.jalousie.configuration.GenericJalousieConfiguration;
import bsc.sdk.api.objects.device.type.jalousie.configuration.JalousieAlignmentPriorityConfiguration;
import bsc.sdk.api.objects.device.type.jalousie.configuration.JalousiePriorityConfiguration;
import bsc.sdk.api.objects.device.type.jalousie.configuration.JalousiePrioritySlowlyDriveConfiguration;
import bsc.sdk.api.objects.device.type.jalousie.configuration.JalousiePriorityTurnAutomaticConfiguration;
import bsc.sdk.api.objects.device.type.jalousie.configuration.JalousieSlatAdjustmentAndTimePriorityConfiguration;
import bsc.sdk.api.objects.device.type.jalousie.configuration.JalousieSlatAdjustmentTimePriorityConfiguration;
import bsc.sdk.api.objects.device.type.jalousie.configuration.SwitchJalousieConfiguration;

public class JalousieFactory
extends DeviceFactory {
    private static JalousieFactory defaultFactory = null;

    public static JalousieFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = JalousieFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(JalousieFactory factory) {
        defaultFactory = factory;
    }

    public static JalousieFactory createDefaultFactory() {
        return new JalousieFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return JalousieFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case SwitchJalousie: {
                return this.createSwitchJalousie((SwitchJalousieConfiguration)deviceConfiguration);
            }
            case JalousiePriority: {
                return this.createJalousiePriority((JalousiePriorityConfiguration)deviceConfiguration);
            }
            case JalousieAlignmentPriority: {
                return this.createJalousieAlignmentPriority((JalousieAlignmentPriorityConfiguration)deviceConfiguration);
            }
            case JalousieSlatAdjustmentTimePriority: {
                return this.createJalousieSlatAdjustmentPriority((JalousieSlatAdjustmentTimePriorityConfiguration)deviceConfiguration);
            }
            case JalousieSlatAdjustmentDirectionTimePriority: {
                return this.createJalousieSlatAdjustmentAndTimePriority((JalousieSlatAdjustmentAndTimePriorityConfiguration)deviceConfiguration);
            }
            case GenericJalousie: {
                return this.createGenericJalousie((GenericJalousieConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    private Device createGenericJalousie(GenericJalousieConfiguration deviceConfiguration) {
        AValueSensor sensor;
        Device device = this.createBasicDevice(deviceConfiguration);
        switch (deviceConfiguration.getSensorType()) {
            case INVERTED: {
                sensor = new JalousieInvertedSensor(deviceConfiguration.getDeviceID());
                break;
            }
            default: {
                sensor = new JalousieSensor(deviceConfiguration.getDeviceID());
            }
        }
        this.fillValueSensor(deviceConfiguration.getSensorType().getParent(), deviceConfiguration.getSensorId(), deviceConfiguration.getValueSettings(), sensor);
        device.addSensor(sensor);
        Jalousie direction = new Jalousie(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Direction, deviceConfiguration.getDirectionSensorId(), deviceConfiguration.getDirection(), direction);
        device.addSensor(direction);
        return device;
    }

    private Device createJalousiePriority(JalousiePriorityConfiguration deviceConfiguration) {
        Device device = this.createGenericJalousie(deviceConfiguration);
        PrioritySensor p = new PrioritySensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Priority, deviceConfiguration.getPrioritySensorId(), deviceConfiguration.getPriorityState(), p);
        device.addSensor(p);
        if (deviceConfiguration instanceof JalousiePrioritySlowlyDriveConfiguration) {
            JalousiePrioritySlowlyDriveConfiguration config = (JalousiePrioritySlowlyDriveConfiguration)deviceConfiguration;
            SlowlyDriveEnabledSensor slowlySensor = new SlowlyDriveEnabledSensor(config.getDeviceID());
            this.fillStateSensor(Enumerations.SensorName.SlowlyDriveEnabled, config.getSlowlyDriveId(), config.getStateSlowlyDrive(), slowlySensor);
            device.addSensor(slowlySensor);
        } else if (deviceConfiguration instanceof JalousiePriorityTurnAutomaticConfiguration) {
            JalousiePriorityTurnAutomaticConfiguration config = (JalousiePriorityTurnAutomaticConfiguration)deviceConfiguration;
            TurnAutomaticEnabledSensor turnAutoSensor = new TurnAutomaticEnabledSensor(config.getDeviceID());
            this.fillStateSensor(Enumerations.SensorName.TurnAutomaticEnabled, config.getTurnAutomaticId(), config.getStateTurnAutomatic(), turnAutoSensor);
            device.addSensor(turnAutoSensor);
        }
        return device;
    }

    private Device createJalousieAlignmentPriority(JalousieAlignmentPriorityConfiguration deviceConfiguration) {
        Device device = this.createJalousiePriority(deviceConfiguration);
        UpSensorSlat alignmentDirection = new UpSensorSlat(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Alignment, deviceConfiguration.getAlignmentDirectionSensorId(), deviceConfiguration.getAlignmentDirectionState(), alignmentDirection);
        device.addSensor(alignmentDirection);
        return device;
    }

    private Device createJalousieSlatAdjustmentPriority(JalousieSlatAdjustmentTimePriorityConfiguration deviceConfiguration) {
        Device device = this.createJalousiePriority(deviceConfiguration);
        ValueSensor adjustingTime = new ValueSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.SlatAdjustmentTime, deviceConfiguration.getSlatAdjustmentTimeSensorId(), deviceConfiguration.getSlatAdjustmentTimeValue(), adjustingTime);
        device.addSensor(adjustingTime);
        return device;
    }

    private Device createJalousieSlatAdjustmentAndTimePriority(JalousieSlatAdjustmentAndTimePriorityConfiguration deviceConfiguration) {
        Device device = this.createJalousieAlignmentPriority(deviceConfiguration);
        ValueSensor adjustingTime = new ValueSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.SlatAdjustmentTime, deviceConfiguration.getSlatAdjustmentTimeSensorId(), deviceConfiguration.getSlatAdjustmentTimeValue(), adjustingTime);
        device.addSensor(adjustingTime);
        JalousieSlat alignmentDirection = new JalousieSlat(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.JalousieSlat, deviceConfiguration.getSlatAdjustmentJalousieSlatId(), deviceConfiguration.getSlatAdjustmentJalousieSlatState(), alignmentDirection);
        device.addSensor(alignmentDirection);
        return device;
    }

    private Device createSwitchJalousie(SwitchJalousieConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        Jalousie direction = new Jalousie(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Direction, deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), direction);
        device.addSensor(direction);
        return device;
    }
}

