/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.direction;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.state.DirectionSensor;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.direction.configuration.KeySwitchConfiguration;

public class DirectionFactory
extends DeviceFactory {
    private static DirectionFactory defaultFactory = null;

    public static DirectionFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = DirectionFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(DirectionFactory factory) {
        defaultFactory = factory;
    }

    public static DirectionFactory createDefaultFactory() {
        return new DirectionFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return DirectionFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case KeySwitch: {
                return this.createDirectionSensorConfig((KeySwitchConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    protected Device createDirectionSensorConfig(KeySwitchConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        DirectionSensor sensor = new DirectionSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.DirectionSensor, deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), sensor);
        device.addSensor(sensor);
        return device;
    }
}

