/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.container;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.state.ActorContainer;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.container.configuration.ActorContainerConfiguration;

public class ContainerFactory
extends DeviceFactory {
    private static ContainerFactory defaultFactory = null;

    public static ContainerFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = ContainerFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(ContainerFactory factory) {
        defaultFactory = factory;
    }

    public static ContainerFactory createDefaultFactory() {
        return new ContainerFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return ContainerFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case ActorContainer: {
                return this.createActorContainer((ActorContainerConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    private Device createActorContainer(ActorContainerConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        ActorContainer sensor = new ActorContainer(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.ActorContainer, deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), sensor);
        device.addSensor(sensor);
        return device;
    }
}

