/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.cardswitch;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.state.CardSwitch;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.cardswitch.configuration.GenericCardSwitchConfiguration;

public class CardSwitchFactory
extends DeviceFactory {
    private static CardSwitchFactory defaultFactory = null;

    public static CardSwitchFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = CardSwitchFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(CardSwitchFactory factory) {
        defaultFactory = factory;
    }

    public static CardSwitchFactory createDefaultFactory() {
        return new CardSwitchFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return CardSwitchFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case GenericCardSwitch: {
                return this.createGenericCardSwitch((GenericCardSwitchConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    protected Device createGenericCardSwitch(GenericCardSwitchConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        CardSwitch sensor = new CardSwitch(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.CardSwitch, deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), sensor);
        device.addSensor(sensor);
        return device;
    }
}

