/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.bsc;

import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ISensor;
import bsc.api.modules.bsc.model.ServerInterface;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.bsc.configuration.ServerInterfaceConfiguration;

public class BscFactory
extends DeviceFactory {
    private static BscFactory defaultFactory = null;

    public static BscFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = BscFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(BscFactory factory) {
        defaultFactory = factory;
    }

    public static BscFactory createDefaultFactory() {
        return new BscFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return BscFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case SystemDevice: {
                return this.createServerInterface((ServerInterfaceConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    protected ADevice createServerInterface(ServerInterfaceConfiguration deviceConfiguration) {
        ServerInterface device = new ServerInterface();
        this.fillDevice(deviceConfiguration, device);
        for (ISensor sensor : deviceConfiguration.getSensors()) {
            sensor.setDeviceID(device.getDeviceID());
            device.addSensor(sensor);
        }
        return device;
    }
}

