/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.brightness;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.state.detection.MotionDetection;
import bsc.api.modules.core.model.sensor.value.BrightnessSensor;
import bsc.api.modules.core.model.sensor.value.ElectricitySensor;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.brightness.configuration.BrightnessDetectionConfiguration;
import bsc.sdk.api.objects.device.type.brightness.configuration.BrightnessVoltageConfiguration;
import bsc.sdk.api.objects.device.type.brightness.configuration.BrightnessVoltageDetectionConfiguration;
import bsc.sdk.api.objects.device.type.brightness.configuration.GenericBrightnessConfiguration;

public class BrightnessFactory
extends DeviceFactory {
    private static BrightnessFactory defaultFactory = null;

    public static BrightnessFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = BrightnessFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(BrightnessFactory factory) {
        defaultFactory = factory;
    }

    public static BrightnessFactory createDefaultFactory() {
        return new BrightnessFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return BrightnessFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case GenericBrightness: {
                return this.createGenericBrightness((GenericBrightnessConfiguration)deviceConfiguration);
            }
            case BrightnessVoltage: {
                return this.createBrightnessVoltage((BrightnessVoltageConfiguration)deviceConfiguration);
            }
            case BrightnessVoltageDetection: {
                return this.createBrightnessVoltageDetection((BrightnessVoltageDetectionConfiguration)deviceConfiguration);
            }
            case BrightnessDetection: {
                return this.createBrightnessDetection((BrightnessDetectionConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    protected Device createBrightnessDetection(BrightnessDetectionConfiguration deviceConfiguration) {
        Device device = this.createGenericBrightness(deviceConfiguration);
        MotionDetection sensor = new MotionDetection(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Detection, deviceConfiguration.getVoltageSensorId(), deviceConfiguration.getDetectionState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createBrightnessVoltageDetection(BrightnessVoltageDetectionConfiguration deviceConfiguration) {
        Device device = this.createBrightnessVoltage(deviceConfiguration);
        MotionDetection sensor = new MotionDetection(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Detection, deviceConfiguration.getDetectionSensorId(), deviceConfiguration.getDetectionCurrentState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createBrightnessVoltage(BrightnessVoltageConfiguration deviceConfiguration) {
        Device device = this.createGenericBrightness(deviceConfiguration);
        ElectricitySensor sensor = new ElectricitySensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.Voltage, deviceConfiguration.getVoltageSensorId(), deviceConfiguration.getVoltageValueSettings(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createGenericBrightness(GenericBrightnessConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        BrightnessSensor sensor = new BrightnessSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.Brightness, deviceConfiguration.getSensorId(), deviceConfiguration.getValueSettings(), sensor);
        device.addSensor(sensor);
        return device;
    }
}

