/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.battery;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.state.check.BatteryCheck;
import bsc.api.modules.core.model.sensor.value.ElectricitySensor;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.battery.configuration.GenericBatteryCheckConfiguration;
import bsc.sdk.api.objects.device.type.battery.configuration.VoltageBatteryCheckConfiguration;

public class BatteryFactory
extends DeviceFactory {
    private static BatteryFactory defaultFactory = null;

    public static BatteryFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = BatteryFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(BatteryFactory factory) {
        defaultFactory = factory;
    }

    public static BatteryFactory createDefaultFactory() {
        return new BatteryFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return BatteryFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case GenericBatteryCheck: {
                return this.createGenericBattery((GenericBatteryCheckConfiguration)deviceConfiguration);
            }
            case VoltageBatteryCheck: {
                return this.createVoltageBattery((VoltageBatteryCheckConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    protected Device createGenericBattery(GenericBatteryCheckConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        BatteryCheck sensor = new BatteryCheck(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Battery, deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createVoltageBattery(VoltageBatteryCheckConfiguration deviceConfiguration) {
        Device device = this.createGenericBattery(deviceConfiguration);
        ElectricitySensor sensor = new ElectricitySensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.Voltage, deviceConfiguration.getVoltageSensorId(), deviceConfiguration.getVoltageValueSettings(), sensor);
        device.addSensor(sensor);
        return device;
    }
}

