/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.alarm;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.state.AlarmSensor;
import bsc.api.modules.core.model.sensor.state.AlarmSirenMonitored;
import bsc.api.modules.core.model.sensor.state.OnSensor;
import bsc.api.modules.core.model.sensor.state.WindowSensor;
import bsc.api.modules.core.model.sensor.state.enabled.AlarmEnabled;
import bsc.api.modules.core.model.sensor.state.enabled.PreAlarmEnabled;
import bsc.api.modules.core.model.sensor.state.trigger.AlarmTrigger;
import bsc.api.modules.core.model.sensor.state.trigger.PreAlarmTrigger;
import bsc.api.modules.core.model.sensor.value.ElectricitySensor;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.alarm.configuration.AlarmRelayConfiguration;
import bsc.sdk.api.objects.device.type.alarm.configuration.AlarmSirenConfiguration;
import bsc.sdk.api.objects.device.type.alarm.configuration.GenericAlarmConfiguration;
import bsc.sdk.api.objects.device.type.alarm.configuration.SmartGuadAlarmConfiguration;
import bsc.sdk.api.objects.device.type.alarm.configuration.SpecialAlarmConfiguration;

public class AlarmFactory
extends DeviceFactory {
    private static AlarmFactory defaultFactory = null;

    public static AlarmFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = AlarmFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(AlarmFactory factory) {
        defaultFactory = factory;
    }

    public static AlarmFactory createDefaultFactory() {
        return new AlarmFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return AlarmFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case SpecialAlarm: {
                return this.createSpecialAlarm((SpecialAlarmConfiguration)deviceConfiguration);
            }
            case AlarmRelay: {
                return this.createAlarmRelay((AlarmRelayConfiguration)deviceConfiguration);
            }
            case GenericAlarm: {
                return this.createGenericAlarm((GenericAlarmConfiguration)deviceConfiguration);
            }
            case AlarmSiren: {
                return this.createAlarmSiren((AlarmSirenConfiguration)deviceConfiguration);
            }
            case Smartguard_Window: {
                return this.createSmartguardAlarm((SmartGuadAlarmConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    private ADevice createSmartguardAlarm(SmartGuadAlarmConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        WindowSensor windowSensor = new WindowSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Window, deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), windowSensor);
        device.addSensor(windowSensor);
        AlarmTrigger alarmTrigger = new AlarmTrigger(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Trigger, deviceConfiguration.getIdAlarm(), deviceConfiguration.getAlarmState(), alarmTrigger);
        device.addSensor(alarmTrigger);
        PreAlarmTrigger preAlarmTrigger = new PreAlarmTrigger(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.PreAlarmTrigger, deviceConfiguration.getIdPreAlarm(), deviceConfiguration.getPreAlarmState(), preAlarmTrigger);
        device.addSensor(preAlarmTrigger);
        AlarmEnabled alarmSetting = new AlarmEnabled(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Enabled, deviceConfiguration.getIdAlarmSetting(), deviceConfiguration.getAlarmSettingState(), alarmSetting);
        device.addSensor(alarmSetting);
        PreAlarmEnabled preAlarmEnabled = new PreAlarmEnabled(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.PreAlarmEnabled, deviceConfiguration.getIdPreAlarmSetting(), deviceConfiguration.getPreAlarmSettingState(), preAlarmEnabled);
        device.addSensor(preAlarmEnabled);
        ElectricitySensor electricitySensor = new ElectricitySensor(device.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.EnergyStorage, deviceConfiguration.getIdEnergyState(), deviceConfiguration.getEnergyValueState(), electricitySensor);
        device.addSensor(electricitySensor);
        device.setDeviceType(Enumerations.DeviceType.Smartguard_Window);
        return device;
    }

    private ADevice createAlarmSiren(AlarmSirenConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        AlarmSirenMonitored alarmON = new AlarmSirenMonitored(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Alarm, deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), alarmON);
        device.addSensor(alarmON);
        device.setDeviceType(Enumerations.DeviceType.AlarmSiren);
        return device;
    }

    private ADevice createSpecialAlarm(SpecialAlarmConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        AlarmTrigger alarmTrigger = new AlarmTrigger(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Trigger, deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), alarmTrigger);
        device.addSensor(alarmTrigger);
        AlarmEnabled alarmEnabled = new AlarmEnabled(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Alarm, deviceConfiguration.getAlarmEnabledId(), deviceConfiguration.getAlarmEnabledState(), alarmEnabled);
        device.addSensor(alarmEnabled);
        device.setDeviceType(Enumerations.DeviceType.AlarmRelay);
        return device;
    }

    private ADevice createAlarmRelay(AlarmRelayConfiguration deviceConfiguration) {
        Device device = this.createGenericAlarm(deviceConfiguration);
        OnSensor sensor = new OnSensor(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Relay, deviceConfiguration.getAlarmSensorId(), deviceConfiguration.getAlarmState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createGenericAlarm(GenericAlarmConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        switch (deviceConfiguration.getSensorType()) {
            default: 
        }
        AlarmSensor sensor = new AlarmSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(deviceConfiguration.getSensorType().getParent(), deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), sensor);
        device.addSensor(sensor);
        return device;
    }
}

