/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.handler.command;

import bsc.api.Enumerations;
import bsc.api.IApiObject;
import bsc.api.transport.result.Result;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.handler.IObjectHandler;
import bsc.sdk.api.handler.ISupportedClass;
import bsc.sdk.api.handler.ObjectHandlerIdentifier;
import bsc.sdk.api.handler.manager.AHandleManager;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;
import bsc.sdk.tools.Tools;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CommandHandler
extends AHandleManager
implements IObjectHandler {
    protected String extensionId = "CUSTOM";
    protected Set<Class<? extends IApiObject>> supportedClasses = new HashSet<Class<? extends IApiObject>>();
    protected Environment environment;
    protected String handlerID;

    public CommandHandler(Enumerations.EXTENSION_ID extensionId, Environment environment) {
        this(extensionId.getId(), environment);
    }

    public CommandHandler(String extensionId, Environment environment) {
        this.environment = environment;
        this.handlerID = environment.getHandleManager().getUniqueHandlerID();
        this.loadExecutors();
        if (extensionId != null) {
            this.extensionId = extensionId;
        }
    }

    @Override
    public Result doHandle(TransceiverIdentifier identifier, IApiObject object) {
        this.logger.trace("Handle Command: " + object.getClass());
        return this.handle(identifier, object);
    }

    @Override
    public boolean isSupported(IApiObject object) {
        return object != null && this.supportedClasses.contains(object.getClass());
    }

    public Set<Class<? extends IApiObject>> getSupportedClasses() {
        return new HashSet<Class<? extends IApiObject>>(this.supportedClasses);
    }

    @Override
    public String getExtensionID() {
        return this.extensionId;
    }

    protected void loadExecutors() {
        this.logger.trace("----------------------------");
        this.logger.trace("Load executors:");
        List<Class<IObjectHandler>> classes = Tools.getClasses(this.getClass().getPackage().getName() + ".executor", IObjectHandler.class);
        for (Class<IObjectHandler> clazz : classes) {
            if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) continue;
            try {
                IObjectHandler executor = clazz.getConstructor(Environment.class).newInstance(this.getEnvironment());
                if (!this.registerHandler(executor)) continue;
                this.supportedClasses.add(((ISupportedClass)((Object)executor)).getSupportedClass());
                this.logger.trace("-> " + executor.getClass().getName());
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                this.logger.error("Failed to create instance for: " + clazz.getName(), (Throwable)e);
            }
        }
        this.logger.trace("----------------------------");
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public String getHandlerID() {
        return this.handlerID;
    }

    @Override
    public URI getURI(String applicationID, String host) {
        return ObjectHandlerIdentifier.generateURI(this.handlerID, applicationID, host);
    }

    @Override
    public URI getURI() {
        return this.getURI(this.getEnvironment().getApplicationId(), this.getEnvironment().getHostID());
    }

    @Override
    public boolean save() {
        return false;
    }

    @Override
    public boolean load() {
        return false;
    }

    @Override
    public boolean save(ObjectHandlerIdentifier identifier) {
        return false;
    }

    @Override
    protected void _shutdown() {
    }
}

