/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.handler;

import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.identifier.AIdentifier;
import bsc.sdk.api.handler.IObjectHandler;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Objects;

public class ObjectHandlerIdentifier
extends AIdentifier<IObjectHandler> {
    public static int OBJECT_HANDLER_ID_PART = 0;
    private final String handlerID = this.getPathPart(OBJECT_HANDLER_ID_PART);

    public ObjectHandlerIdentifier(URI uri) throws URISyntaxException {
        super(uri);
    }

    public String getHandlerID() {
        return this.handlerID;
    }

    public static URI generateURI(String handlerID, String applicationID, String host) {
        if (handlerID != null && applicationID != null && host != null) {
            try {
                String uriString = IObjectHandler.class.getSimpleName() + "://" + applicationID + "@" + host + "/" + URLEncoder.encode(handlerID, "UTF-8");
                return new URI(uriString);
            }
            catch (UnsupportedEncodingException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static URI generateURI(String handlerID, Environment enviromentSettings) {
        return ObjectHandlerIdentifier.generateURI(handlerID, Objects.requireNonNull(enviromentSettings, "enviromentSettings must not be null!").getApplicationId(), enviromentSettings.getHostID());
    }

    public static ObjectHandlerIdentifier createIdentifierInstance(String handlerID, Environment enviromentSettings) throws URISyntaxException {
        return new ObjectHandlerIdentifier(ObjectHandlerIdentifier.generateURI(handlerID, enviromentSettings));
    }

    public static ObjectHandlerIdentifier createIdentifierInstance(IObjectHandler objectHandler, Environment enviromentSettings) throws URISyntaxException {
        return new ObjectHandlerIdentifier(ObjectHandlerIdentifier.generateURI(Objects.requireNonNull(objectHandler, "objectHandler must not be null!").getHandlerID(), enviromentSettings));
    }

    @Override
    public IObjectHandler getObjectInstance() {
        return (IObjectHandler)this.environment.getHandleManager().getObjectInstance(this);
    }

    @Override
    public boolean deleteObject() {
        return this.environment.getHandleManager().removeHandler(this);
    }

    @Override
    public boolean updateObject(IObjectHandler objectInstance) {
        return false;
    }

    @Override
    public boolean saveObject() {
        return this.environment.getHandleManager().save(this);
    }
}

