/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.notification;

import bsc.api.Enumerations;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.IExtension;
import bsc.sdk.api.extension.notification.IObjectNotificationListener;
import bsc.sdk.api.notification.ANotificationExecutor;
import bsc.sdk.api.notification.INotification;
import bsc.sdk.tools.Tools;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AObjectNotificationListener<T extends INotification>
implements IObjectNotificationListener {
    private Class<T> clazz;
    private Environment environment;
    private String extensionId;
    private ANotificationExecutor<T> executor;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public AObjectNotificationListener(String extensionId, ANotificationExecutor<T> executor, Environment enviroment) {
        Class<?> clazz;
        this.environment = Objects.requireNonNull(enviroment, "enviromentSettings must not be null!");
        this.extensionId = Objects.requireNonNull(extensionId, "ExtensionId must not be null!");
        this.executor = Objects.requireNonNull(executor, "executor must not be null!");
        Type type = clazz.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            this.clazz = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        } else {
            String name = clazz.getSimpleName();
            for (clazz = this.getClass(); !name.contains("$$006") && clazz != Object.class; clazz = clazz.getSuperclass()) {
                name = clazz.getSimpleName();
            }
            if (clazz == Object.class) {
                throw new RuntimeException("Unable to resolve class");
            }
            this.clazz = (Class)Tools.getActualTypeArguments(name)[0];
        }
    }

    public AObjectNotificationListener(Enumerations.EXTENSION_ID extensionId, ANotificationExecutor<T> executor, Environment enviroment) {
        this(Objects.requireNonNull(extensionId, "ExtensionId must not be null!").getId(), executor, enviroment);
    }

    @Override
    public void notificationReceived(INotification notification) {
        if (notification != null && notification.getClass().equals(this.clazz)) {
            this.logger.trace("Calling executor: " + this.executor.getClass().getName());
            this.executor.execute(this, notification);
        }
    }

    @Override
    public Class<?> getSupportedClass() {
        return this.clazz;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public String getExtensionId() {
        return this.extensionId;
    }

    public IExtension getExtension() {
        return this.getEnvironment().getExtensionManager().getExtension(this.getExtensionId());
    }
}

