/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.userconfig.notification;

import bsc.api.basic.model.ADevice;
import bsc.api.modules.bsc.model.ServerInterface;
import bsc.api.modules.userconfig.commands.offer.ChangePasswordOffer;
import bsc.api.modules.userconfig.commands.offer.ClearConfigStorageOffer;
import bsc.api.modules.userconfig.commands.offer.GetConfigValuesOffer;
import bsc.api.modules.userconfig.commands.offer.PutConfigValuesOffer;
import bsc.api.modules.userconfig.commands.offer.SetUserEmailOffer;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.userconfig.notification.AUserConfigNotification;
import bsc.sdk.api.extension.notification.AObjectNotificationListener;
import bsc.sdk.api.notification.ANotificationExecutor;
import bsc.sdk.api.notification.objects.AddDeviceOffers;
import bsc.sdk.api.user.group.Permission;
import java.util.EnumSet;

public class AddDeviceOffersHandler
extends AUserConfigNotification<AddDeviceOffers> {
    private static ANotificationExecutor<AddDeviceOffers> executor = new ANotificationExecutor<AddDeviceOffers>(){

        @Override
        public void execute(AObjectNotificationListener<AddDeviceOffers> parent, AddDeviceOffers object) {
            ADevice device = object.getDevice();
            EnumSet<Permission> rights = object.getPermissions();
            if (device instanceof ServerInterface && rights.contains((Object)Permission.CONFIGURE)) {
                device.addCommandOffer(new ClearConfigStorageOffer());
                device.addCommandOffer(new GetConfigValuesOffer());
                device.addCommandOffer(new PutConfigValuesOffer());
                device.addCommandOffer(new ChangePasswordOffer());
                device.addCommandOffer(new SetUserEmailOffer());
            }
        }
    };

    public AddDeviceOffersHandler(Environment enviromentSettings) {
        super(AddDeviceOffersHandler.getExecutor(), enviromentSettings);
    }

    public static ANotificationExecutor<AddDeviceOffers> getExecutor() {
        return executor;
    }

    public static void setExecutor(ANotificationExecutor<AddDeviceOffers> executor) {
        AddDeviceOffersHandler.executor = executor;
    }
}

