/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.timer.notification;

import bsc.api.basic.model.ADevice;
import bsc.api.modules.bsc.model.ServerInterface;
import bsc.api.modules.timer.commands.offer.AddTimerOffer;
import bsc.api.modules.timer.commands.offer.ClockModeTimerControlOffer;
import bsc.api.modules.timer.commands.offer.ConfigureTimerOffer;
import bsc.api.modules.timer.commands.offer.DateModeTimerControlOffer;
import bsc.api.modules.timer.commands.offer.DisableTimerOffer;
import bsc.api.modules.timer.commands.offer.EnableTimerOffer;
import bsc.api.modules.timer.commands.offer.GetTImersOffer;
import bsc.api.modules.timer.commands.offer.IntervalModeTimerControlOffer;
import bsc.api.modules.timer.commands.offer.OverrunModeTimerControlOffer;
import bsc.api.modules.timer.commands.offer.ProgModeTimerControlOffer;
import bsc.api.modules.timer.commands.offer.TimeModeTimerControlOffer;
import bsc.api.modules.timer.model.Timer;
import bsc.api.modules.timer.model.TimerControl;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.timer.notification.ATimerNotification;
import bsc.sdk.api.extension.notification.AObjectNotificationListener;
import bsc.sdk.api.notification.ANotificationExecutor;
import bsc.sdk.api.notification.objects.AddDeviceOffers;
import bsc.sdk.api.user.group.Permission;
import java.util.EnumSet;

public class AddDeviceOffersHandler
extends ATimerNotification<AddDeviceOffers> {
    private static ANotificationExecutor<AddDeviceOffers> executor = new ANotificationExecutor<AddDeviceOffers>(){

        @Override
        public void execute(AObjectNotificationListener<AddDeviceOffers> parent, AddDeviceOffers object) {
            ADevice device = object.getDevice();
            EnumSet<Permission> rights = object.getPermissions();
            if (device instanceof ServerInterface) {
                if (rights.contains((Object)Permission.CONFIGURE)) {
                    device.addCommandOffer(new AddTimerOffer());
                    device.addCommandOffer(new ConfigureTimerOffer());
                    device.addCommandOffer(new EnableTimerOffer());
                    device.addCommandOffer(new DisableTimerOffer());
                }
                if (rights.contains((Object)Permission.VIEW)) {
                    device.addCommandOffer(new GetTImersOffer());
                }
            }
            if (device instanceof Timer && rights.contains((Object)Permission.CONFIGURE)) {
                device.addCommandOffer(new ConfigureTimerOffer());
                device.addCommandOffer(new EnableTimerOffer());
                device.addCommandOffer(new DisableTimerOffer());
            }
            if (rights.contains((Object)Permission.CONFIGURE) && device instanceof TimerControl) {
                device.addCommandOffer(new ClockModeTimerControlOffer());
                device.addCommandOffer(new TimeModeTimerControlOffer());
                device.addCommandOffer(new DateModeTimerControlOffer());
                device.addCommandOffer(new ProgModeTimerControlOffer());
                device.addCommandOffer(new IntervalModeTimerControlOffer());
                device.addCommandOffer(new OverrunModeTimerControlOffer());
            }
        }
    };

    public AddDeviceOffersHandler(Environment enviromentSettings) {
        super(executor, enviromentSettings);
    }

    public static ANotificationExecutor<AddDeviceOffers> getExecutor() {
        return executor;
    }

    public static void setExecutor(ANotificationExecutor<AddDeviceOffers> executor) {
        AddDeviceOffersHandler.executor = executor;
    }
}

