/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.teachin.referenceid.tools;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ISensor;
import bsc.api.modules.core.model.sensor.AStateSensor;
import bsc.api.modules.core.model.sensor.AValueSensor;
import bsc.api.modules.teachin.referenceid.IReferenceID;
import bsc.api.modules.teachin.referenceid.ReferenceIDs;
import bsc.sdk.api.extension.modules.teachin.notification.AddMetaDataHandler;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceValidator {
    private Logger logger = null;

    public static void main(String[] args) {
        IReferenceID refID = ReferenceIDs.getReferenceIDbyString("enocean.eltako.fsb14_4_2");
        ArrayList<ReferenceIDs.SensorEntry> sensorIndex = refID.getSensorIndex();
        for (int i = 0; i < sensorIndex.size(); ++i) {
            System.out.println(i + 1 + ": " + sensorIndex.get(i));
        }
    }

    public DeviceValidator() {
        this(LoggerFactory.getLogger(DeviceValidator.class));
    }

    public DeviceValidator(Logger logger) {
        this.logger = logger;
    }

    public boolean validateDevice(ADevice device) {
        boolean valid = true;
        String referenceID = device.getMetaInformation(Enumerations.EXTENSION_ID.TEACHIN.name(), AddMetaDataHandler.DETAILS.REFERENCE_ID.name());
        IReferenceID refIDObj = ReferenceIDs.getReferenceIDbyString(referenceID);
        ArrayList<ReferenceIDs.SensorEntry> entries = refIDObj.getSensorIndex();
        Iterator<ReferenceIDs.SensorEntry> seItr = entries.iterator();
        while (seItr.hasNext()) {
            boolean validSensor = true;
            ReferenceIDs.SensorEntry entry = seItr.next();
            String sensorName = entry.getName();
            String type = entry.getType();
            ISensor sensor = device.getSensorByName(sensorName);
            if (sensor == null) {
                this.logger.warn("Invalid device: " + device.getDeviceID() + " missing sensor name : " + sensorName + " for " + referenceID);
                validSensor = false;
            } else {
                Enumerations.SensorName.TYPE t = Enumerations.SensorName.TYPE.valueOf(type);
                if (t != null) {
                    switch (t) {
                        case STATE: {
                            if (sensor instanceof AStateSensor) break;
                            validSensor = false;
                            break;
                        }
                        case VALUE: {
                            if (sensor instanceof AValueSensor) break;
                            validSensor = false;
                            break;
                        }
                    }
                    if (!validSensor) {
                        this.logger.warn("[" + device.getDeviceID() + "] Invalid sensor type " + type + " for " + sensorName + " sensor class: " + sensor.getClass().getName());
                    }
                }
            }
            if (validSensor) continue;
            valid = false;
        }
        return valid;
    }
}

