/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.heater.notification;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.bsc.model.ServerInterface;
import bsc.api.modules.heater.commands.offer.AddHeaterControlOffer;
import bsc.api.modules.heater.commands.offer.AssignOnOffSensorOffer;
import bsc.api.modules.heater.commands.offer.AssignSetPointSensorOffer;
import bsc.api.modules.heater.commands.offer.AssignTempSensorOffer;
import bsc.api.modules.heater.commands.offer.GetHeatersOffer;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.heater.notification.AHeaterNotification;
import bsc.sdk.api.extension.notification.AObjectNotificationListener;
import bsc.sdk.api.notification.ANotificationExecutor;
import bsc.sdk.api.notification.objects.AddDeviceOffers;
import bsc.sdk.api.user.group.Permission;
import java.util.EnumSet;

public class AddDeviceOffersHandler
extends AHeaterNotification<AddDeviceOffers> {
    private static ANotificationExecutor<AddDeviceOffers> executor = new ANotificationExecutor<AddDeviceOffers>(){

        @Override
        public void execute(AObjectNotificationListener<AddDeviceOffers> parent, AddDeviceOffers object) {
            ADevice device = object.getDevice();
            EnumSet<Permission> rights = object.getPermissions();
            if (device instanceof ServerInterface) {
                if (rights.contains((Object)Permission.CONFIGURE)) {
                    device.addCommandOffer(new AddHeaterControlOffer());
                }
                if (rights.contains((Object)Permission.VIEW)) {
                    device.addCommandOffer(new GetHeatersOffer());
                }
            } else if (device.getDeviceType().equals((Object)Enumerations.DeviceType.HeaterControl) && rights.contains((Object)Permission.CONFIGURE)) {
                device.addCommandOffer(new AssignSetPointSensorOffer());
                device.addCommandOffer(new AssignTempSensorOffer());
                device.addCommandOffer(new AssignOnOffSensorOffer());
            }
        }
    };

    public AddDeviceOffersHandler(Environment enviromentSettings) {
        super(executor, enviromentSettings);
    }

    public static ANotificationExecutor<AddDeviceOffers> getExecutor() {
        return executor;
    }

    public static void setExecutor(ANotificationExecutor<AddDeviceOffers> executor) {
        AddDeviceOffersHandler.executor = executor;
    }
}

