/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.core.object;

import bsc.api.Enumerations;
import bsc.api.IApiObject;
import bsc.api.IIdentifiableApiObject;
import bsc.api.basic.container.ObjectContainer;
import bsc.api.transport.model.Ping;
import bsc.api.transport.model.ProgressStatus;
import bsc.api.transport.result.OkResult;
import bsc.api.transport.result.Result;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.handler.IHandleExecutor;
import bsc.sdk.api.handler.object.AObjectHandler;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;

public class ObjectHandler
extends AObjectHandler {
    private static IHandleExecutor executor = new IHandleExecutor(){

        @Override
        public Result doHandle(TransceiverIdentifier identifier, IApiObject object) {
            if (object instanceof ProgressStatus) {
                identifier.getEnvironment().getTransmissionManager().attachProgressStatus((ProgressStatus)object);
            } else if (object instanceof IIdentifiableApiObject || object instanceof ObjectContainer) {
                identifier.getEnvironment().getApplication().publishObject(Enumerations.OBJECT_BUS_TAGS.RECEIVED_OBJECT, (Object)object);
            }
            return new OkResult();
        }
    };

    public ObjectHandler(Environment environment) {
        super(Enumerations.EXTENSION_ID.CORE, environment, executor);
    }

    @Override
    public boolean isSupported(IApiObject object) {
        return object instanceof IIdentifiableApiObject || object instanceof Ping || object instanceof ProgressStatus || object instanceof ObjectContainer;
    }

    public static IHandleExecutor getExecutor() {
        return executor;
    }

    public static void setExecutor(IHandleExecutor executor) {
        ObjectHandler.executor = executor;
    }
}

