/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.core.notification;

import bsc.api.basic.model.ISensor;
import bsc.api.modules.core.commands.offer.SetStringsOffer;
import bsc.api.modules.core.commands.offer.StateOffer;
import bsc.api.modules.core.commands.offer.ValueOffer;
import bsc.api.modules.core.commands.offer.state.ActorContainerOffer;
import bsc.api.modules.core.model.sensor.AStateSensor;
import bsc.api.modules.core.model.sensor.AValueSensor;
import bsc.api.modules.core.model.sensor.state.ACNFSlideSwitch;
import bsc.api.modules.core.model.sensor.state.ActorContainer;
import bsc.api.modules.core.model.sensor.state.AlarmSensor;
import bsc.api.modules.core.model.sensor.state.AutoSensor;
import bsc.api.modules.core.model.sensor.state.ButtonSensor;
import bsc.api.modules.core.model.sensor.state.CardSwitch;
import bsc.api.modules.core.model.sensor.state.CheckSensor;
import bsc.api.modules.core.model.sensor.state.DayNightSensor;
import bsc.api.modules.core.model.sensor.state.DetectionSensor;
import bsc.api.modules.core.model.sensor.state.DigitalSensor;
import bsc.api.modules.core.model.sensor.state.EnabledSensor;
import bsc.api.modules.core.model.sensor.state.FanSpeedStateSensor;
import bsc.api.modules.core.model.sensor.state.LoadTypeSensor;
import bsc.api.modules.core.model.sensor.state.OnSensor;
import bsc.api.modules.core.model.sensor.state.OpenSensor;
import bsc.api.modules.core.model.sensor.state.OperatingMode;
import bsc.api.modules.core.model.sensor.state.OperatingModeRestriction;
import bsc.api.modules.core.model.sensor.state.StateHelper;
import bsc.api.modules.core.model.sensor.state.UpSensor;
import bsc.api.modules.core.model.sensor.state.UpSensorSlat;
import bsc.api.modules.core.model.sensor.state.WindowSensor;
import bsc.api.modules.core.model.sensor.value.StringValueSensor;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.core.notification.ACoreNotification;
import bsc.sdk.api.extension.notification.AObjectNotificationListener;
import bsc.sdk.api.notification.ANotificationExecutor;
import bsc.sdk.api.notification.objects.AddSensorOffers;
import bsc.sdk.api.user.group.Permission;
import java.util.EnumSet;

public class AddSensorOffersHandler
extends ACoreNotification<AddSensorOffers> {
    private static ANotificationExecutor<AddSensorOffers> executor = new ANotificationExecutor<AddSensorOffers>(){

        @Override
        public void execute(AObjectNotificationListener<AddSensorOffers> parent, AddSensorOffers object) {
            ISensor sensor = object.getSensor();
            EnumSet<Permission> rights = object.getRights();
            if (rights.contains((Object)Permission.CONFIGURE) && sensor instanceof StringValueSensor) {
                sensor.addCommandOffer(new SetStringsOffer());
            }
            if (rights.contains((Object)Permission.EXECUTE)) {
                if (sensor instanceof AValueSensor) {
                    AValueSensor vs = (AValueSensor)sensor;
                    ValueOffer offer = new ValueOffer();
                    offer.setMaxValue(vs.getMaxValue());
                    offer.setMinValue(vs.getMinValue());
                    offer.setStep(vs.getStepping());
                    sensor.addCommandOffer(offer);
                } else if (sensor instanceof WindowSensor) {
                    WindowSensor ss = (WindowSensor)sensor;
                    this.addStateOffers((Enum)ss.getState(), ss);
                } else if (sensor instanceof UpSensor) {
                    UpSensor ss = (UpSensor)sensor;
                    this.addStateOffers((Enum)ss.getState(), ss);
                } else if (sensor instanceof OperatingMode) {
                    OperatingMode ss = (OperatingMode)sensor;
                    this.addStateOffers((Enum)ss.getState(), ss);
                } else if (sensor instanceof OperatingModeRestriction) {
                    OperatingModeRestriction ss = (OperatingModeRestriction)sensor;
                    this.addStateOffers((Enum)ss.getState(), ss);
                } else if (sensor instanceof OpenSensor) {
                    OpenSensor ss = (OpenSensor)sensor;
                    this.addStateOffers((Enum)ss.getState(), ss);
                } else if (sensor instanceof OnSensor) {
                    OnSensor ss = (OnSensor)sensor;
                    this.addStateOffers((Enum)ss.getState(), ss);
                } else if (sensor instanceof LoadTypeSensor) {
                    LoadTypeSensor ss = (LoadTypeSensor)sensor;
                    this.addStateOffers((Enum)ss.getState(), ss);
                } else if (sensor instanceof FanSpeedStateSensor) {
                    FanSpeedStateSensor ss = (FanSpeedStateSensor)sensor;
                    this.addStateOffers((Enum)ss.getState(), ss);
                } else if (sensor instanceof EnabledSensor) {
                    EnabledSensor ss = (EnabledSensor)sensor;
                    this.addStateOffers((Enum)ss.getState(), ss);
                } else if (sensor instanceof AlarmSensor) {
                    AlarmSensor ss = (AlarmSensor)sensor;
                    this.addStateOffers((Enum)ss.getState(), ss);
                } else if (sensor instanceof DigitalSensor) {
                    DigitalSensor ss = (DigitalSensor)sensor;
                    this.addStateOffers((Enum)ss.getState(), ss);
                } else if (sensor instanceof DetectionSensor) {
                    DetectionSensor ss = (DetectionSensor)sensor;
                    this.addStateOffers((Enum)ss.getState(), ss);
                } else if (sensor instanceof DayNightSensor) {
                    DayNightSensor ss = (DayNightSensor)sensor;
                    this.addStateOffers((Enum)ss.getState(), ss);
                } else if (sensor instanceof CheckSensor) {
                    CheckSensor ss = (CheckSensor)sensor;
                    this.addStateOffers((Enum)ss.getState(), ss);
                } else if (sensor instanceof CardSwitch) {
                    CardSwitch ss = (CardSwitch)sensor;
                    this.addStateOffers((Enum)ss.getState(), ss);
                } else if (sensor instanceof ButtonSensor) {
                    ButtonSensor ss = (ButtonSensor)sensor;
                    this.addStateOffers((Enum)ss.getState(), ss);
                } else if (sensor instanceof AutoSensor) {
                    AutoSensor ss = (AutoSensor)sensor;
                    this.addStateOffers((Enum)ss.getState(), ss);
                } else if (sensor instanceof ActorContainer) {
                    ActorContainer ss = (ActorContainer)sensor;
                    this.addStateOffers((Enum)ss.getState(), ss);
                } else if (sensor instanceof ACNFSlideSwitch) {
                    ACNFSlideSwitch ss = (ACNFSlideSwitch)sensor;
                    this.addStateOffers((Enum)ss.getState(), ss);
                } else if (sensor instanceof UpSensorSlat) {
                    UpSensorSlat ss = (UpSensorSlat)sensor;
                    this.addStateOffers((Enum)ss.getState(), ss);
                }
            }
        }

        protected <T extends Enum<T>> void addStateOffers(T currentState, AStateSensor<T> sensor) {
            if (sensor instanceof ActorContainer) {
                ActorContainerOffer aco = new ActorContainerOffer();
                ActorContainer.State state = (ActorContainer.State)((Object)sensor.getState());
                aco.setPossibleStates(StateHelper.getNextPossibleStates(state));
                sensor.addCommandOffer(aco);
            } else {
                StateOffer<T> offer = new StateOffer<T>();
                offer.setPossibleStates(StateHelper.getNextPossibleStates(sensor.getState()));
                sensor.addCommandOffer(offer);
            }
        }
    };

    public AddSensorOffersHandler(Environment enviromentSettings) {
        super(executor, enviromentSettings);
    }

    public static ANotificationExecutor<AddSensorOffers> getExecutor() {
        return executor;
    }

    public static void setExecutor(ANotificationExecutor<AddSensorOffers> executor) {
        AddSensorOffersHandler.executor = executor;
    }
}

