/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.core.command.executor;

import bsc.api.modules.core.commands.actor.ValueCommand;
import bsc.api.modules.core.model.sensor.AValueSensor;
import bsc.api.transport.result.ExceptionResult;
import bsc.api.transport.result.FailResult;
import bsc.api.transport.result.OkResult;
import bsc.api.transport.result.Result;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.core.command.ACoreExecutor;
import bsc.sdk.api.handler.command.Executable;
import bsc.sdk.api.objects.manager.SensorIdentifier;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;

public class ValueExecutor
extends ACoreExecutor<ValueCommand> {
    private static Executable<ValueCommand> executable = new Executable<ValueCommand>(){

        @Override
        public Result execute(TransceiverIdentifier identifier, ValueCommand command) {
            try {
                Environment environment = identifier.getEnvironment();
                SensorIdentifier sensorIdentifier = SensorIdentifier.createIdentifierInstance(command.getDeviceID(), command.getSensorID(), environment);
                AValueSensor sensor = (AValueSensor)sensorIdentifier.getObjectInstance();
                sensor.setValue(command.getNewValue());
                if (sensorIdentifier.updateObject(sensor)) {
                    return new OkResult();
                }
                return new FailResult("Failed to update object!");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                return new ExceptionResult(e.getCause());
            }
        }
    };

    public ValueExecutor(Environment enviromentSettings) {
        super(executable, enviromentSettings);
    }

    public static Executable<ValueCommand> getExecutable() {
        return executable;
    }

    public static void setExecutable(Executable<ValueCommand> executable) {
        ValueExecutor.executable = executable;
    }
}

