/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.core.command.executor;

import bsc.api.modules.core.commands.actor.StateCommand;
import bsc.api.modules.core.model.sensor.AStateSensor;
import bsc.api.transport.result.ExceptionResult;
import bsc.api.transport.result.FailResult;
import bsc.api.transport.result.OkResult;
import bsc.api.transport.result.Result;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.core.command.ACoreExecutor;
import bsc.sdk.api.handler.command.Executable;
import bsc.sdk.api.objects.manager.SensorIdentifier;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;

public class StateExecutor
extends ACoreExecutor<StateCommand> {
    private static Executable<StateCommand> executable = new Executable<StateCommand>(){

        @Override
        public Result execute(TransceiverIdentifier identifier, StateCommand command) {
            try {
                Environment environment = identifier.getEnvironment();
                SensorIdentifier sensorIdentifier = SensorIdentifier.createIdentifierInstance(command.getDeviceID(), command.getSensorID(), environment);
                AStateSensor sensor = (AStateSensor)sensorIdentifier.getObjectInstance();
                sensor.setState(command.getNewState());
                if (sensorIdentifier.updateObject(sensor)) {
                    return new OkResult();
                }
                return new FailResult("Failed to update object!");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                return new ExceptionResult(e.getCause());
            }
        }
    };

    public StateExecutor(Environment enviromentSettings) {
        super(executable, enviromentSettings);
    }

    public static Executable<StateCommand> getExecutable() {
        return executable;
    }

    public static void setExecutable(Executable<StateCommand> executable) {
        StateExecutor.executable = executable;
    }
}

