/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.core.command.executor;

import bsc.api.IIdentifiableApiObject;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.bsc.model.ServerInterface;
import bsc.api.modules.core.commands.GetServerInterfaceCommand;
import bsc.api.transport.result.FailResult;
import bsc.api.transport.result.ObjectResult;
import bsc.api.transport.result.Result;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.core.command.ACoreExecutor;
import bsc.sdk.api.handler.command.Executable;
import bsc.sdk.api.objects.manager.DeviceIdentifier;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;

public class GetServerInterfaceExecutor
extends ACoreExecutor<GetServerInterfaceCommand> {
    private static Executable<GetServerInterfaceCommand> executable = new CommandExecutor(ServerInterface.class.getSimpleName());

    public GetServerInterfaceExecutor(Environment enviromentSettings) {
        super(executable, enviromentSettings);
    }

    public static void setExecutable(Executable<GetServerInterfaceCommand> executable) {
        GetServerInterfaceExecutor.executable = executable;
    }

    public static Executable<GetServerInterfaceCommand> getExecutable() {
        return executable;
    }

    public static class CommandExecutor
    extends Executable<GetServerInterfaceCommand> {
        protected Collection<String> serverInterfaceIDs = new HashSet<String>();

        public CommandExecutor(String ... serverInterfaceIDs) {
            this.addServerInterfaceIDs(serverInterfaceIDs);
        }

        public void addServerInterfaceIDs(String ... serverInterfaceIDs) {
            if (serverInterfaceIDs != null) {
                for (String id : serverInterfaceIDs) {
                    if (id == null) continue;
                    this.serverInterfaceIDs.add(id);
                }
            }
        }

        public void removeServerInterfaceIDs(String ... serverInterfaceIDs) {
            if (serverInterfaceIDs != null) {
                for (String id : serverInterfaceIDs) {
                    if (id == null) continue;
                    this.serverInterfaceIDs.remove(id);
                }
            }
        }

        @Override
        public Result execute(TransceiverIdentifier identifier, GetServerInterfaceCommand command) {
            Environment environment = identifier.getEnvironment();
            UserCredentialIdentifier userCredentialIdentifier = identifier.getUserCredentialIdentifier();
            Result result = null;
            for (String deviceID : this.serverInterfaceIDs) {
                try {
                    DeviceIdentifier di = DeviceIdentifier.createIdentifierInstance(deviceID, environment);
                    IIdentifiableApiObject obj = di.getUserObjectInstance(userCredentialIdentifier);
                    if (obj == null) continue;
                    result = new ObjectResult(obj);
                    break;
                }
                catch (URISyntaxException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (result == null) {
                for (ADevice device : userCredentialIdentifier.getAccessibleDevices()) {
                    if (!(device instanceof ServerInterface)) continue;
                    result = new ObjectResult(result);
                    break;
                }
            }
            return result != null ? result : new FailResult("Object not found!");
        }
    }
}

