/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.core.command.executor;

import bsc.api.Enumerations;
import bsc.api.IIdentifiableApiObject;
import bsc.api.basic.container.ObjectContainer;
import bsc.api.basic.model.ISensor;
import bsc.api.modules.IModuleClass;
import bsc.api.modules.core.commands.GetSensorsCommand;
import bsc.api.transport.result.FailResult;
import bsc.api.transport.result.ObjectResult;
import bsc.api.transport.result.Result;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.core.command.ACoreExecutor;
import bsc.sdk.api.handler.command.Executable;
import bsc.sdk.api.transceiver.controller.impl.TransceiverController;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import bsc.sdk.api.user.session.ISession;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class GetSensorsExecutor
extends ACoreExecutor<GetSensorsCommand> {
    private static Executable<GetSensorsCommand> executable = new CommandExecutor();

    public GetSensorsExecutor(Environment enviromentSettings) {
        super(executable, enviromentSettings);
    }

    public static void setExecutable(Executable<GetSensorsCommand> executable) {
        GetSensorsExecutor.executable = executable;
    }

    public static Executable<GetSensorsCommand> getExecutable() {
        return executable;
    }

    public static class CommandExecutor
    extends Executable<GetSensorsCommand> {
        @Override
        public Result execute(TransceiverIdentifier identifier, GetSensorsCommand command) {
            Environment environment = identifier.getEnvironment();
            TransceiverController controller = identifier.getControllerInstance();
            ISession session = controller.getCurrentSessionID().getObjectInstance();
            UserCredentialIdentifier userCredentialIdentifier = identifier.getUserCredentialIdentifier();
            if (session != null) {
                Set<ISensor> sensors = userCredentialIdentifier.getAccessibleSensors();
                if (command.getSensorIDs() != null && !command.getSensorIDs().isEmpty()) {
                    Iterator<ISensor> itr = sensors.iterator();
                    while (itr.hasNext()) {
                        boolean requestedID;
                        ISensor sensor = itr.next();
                        String objectExtensionID = null;
                        try {
                            objectExtensionID = environment.getExtensionManager().getObjectExtensionID((IModuleClass)((Object)sensor));
                        }
                        catch (Exception e) {
                            this.logger.error(e.getMessage(), (Throwable)e);
                        }
                        boolean validObjectForTransceiver = objectExtensionID == null ? false : environment.getExtensionManager().isSubscribedFor(identifier, objectExtensionID);
                        boolean bl = requestedID = command.getSensorIDs().contains(sensor.getSensorID()) || command.getSensorIDs().contains(sensor.getDeviceID() + sensor.getSensorID()) || command.getSensorIDs().contains(sensor.getClass().getName());
                        if (command.isExcludeIDs()) {
                            boolean bl2 = requestedID = !requestedID;
                        }
                        if (validObjectForTransceiver && requestedID) continue;
                        itr.remove();
                    }
                } else {
                    return new FailResult(Enumerations.ErrorType.NO_RESULT);
                }
                return new ObjectResult(new ObjectContainer((Collection<IIdentifiableApiObject>)new HashSet<IIdentifiableApiObject>(sensors)));
            }
            return new FailResult(Enumerations.ErrorType.SESSION_NOT_FOUND);
        }
    }
}

