/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.core.command.executor;

import bsc.api.Enumerations;
import bsc.api.IIdentifiableApiObject;
import bsc.api.basic.container.ObjectContainer;
import bsc.api.basic.container.TYPE;
import bsc.api.modules.core.commands.GetGroupsCommand;
import bsc.api.modules.core.model.Group;
import bsc.api.transport.result.FailResult;
import bsc.api.transport.result.ObjectResult;
import bsc.api.transport.result.Result;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.core.command.ACoreExecutor;
import bsc.sdk.api.handler.command.Executable;
import bsc.sdk.api.objects.manager.ObjectIdentifier;
import bsc.sdk.api.transceiver.controller.impl.TransceiverController;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import bsc.sdk.api.user.session.ISession;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;

public class GetGroupsExecutor
extends ACoreExecutor<GetGroupsCommand> {
    private static Executable<GetGroupsCommand> executable = new CommandExecutor();

    public GetGroupsExecutor(Environment enviromentSettings) {
        super(executable, enviromentSettings);
    }

    public static void setExecutable(Executable<GetGroupsCommand> executable) {
        GetGroupsExecutor.executable = executable;
    }

    public static Executable<GetGroupsCommand> getExecutable() {
        return executable;
    }

    public static class CommandExecutor
    extends Executable<GetGroupsCommand> {
        @Override
        public Result execute(TransceiverIdentifier identifier, GetGroupsCommand command) {
            long startTimestamp = System.currentTimeMillis();
            Environment environment = identifier.getEnvironment();
            TransceiverController controller = identifier.getControllerInstance();
            ISession session = controller.getCurrentSessionID().getObjectInstance();
            UserCredentialIdentifier userCredentialIdentifier = identifier.getUserCredentialIdentifier();
            Result result = null;
            if (session != null) {
                HashSet<IIdentifiableApiObject> groups = new HashSet<IIdentifiableApiObject>(environment.getObjectManager().getObjectsForUser(userCredentialIdentifier, EnumSet.of(ObjectIdentifier.OBJECT_TYPE.GROUP), false));
                if (command.getIDs() != null && !command.getIDs().isEmpty()) {
                    Iterator itr = groups.iterator();
                    while (itr.hasNext()) {
                        boolean requestedID;
                        boolean validObjectForTransceiver;
                        Group group = (Group)itr.next();
                        String objectExtensionID = null;
                        try {
                            objectExtensionID = environment.getExtensionManager().getObjectExtensionID(group);
                        }
                        catch (Exception e) {
                            this.logger.error(e.getMessage(), (Throwable)e);
                        }
                        boolean bl = validObjectForTransceiver = objectExtensionID == null ? false : environment.getExtensionManager().isSubscribedFor(identifier, objectExtensionID);
                        boolean bl2 = command.isExcludeIDs() ? !command.getIDs().contains(group.getId()) : (requestedID = command.getIDs().contains(group.getId()));
                        if (validObjectForTransceiver && requestedID) continue;
                        itr.remove();
                    }
                }
                result = new ObjectResult(new ObjectContainer(TYPE.INCREMENTAL, (Collection<IIdentifiableApiObject>)new HashSet<IIdentifiableApiObject>(groups)));
            } else {
                result = new FailResult(Enumerations.ErrorType.SESSION_NOT_FOUND);
            }
            this.logger.trace("Gathering group objects takes: " + (System.currentTimeMillis() - startTimestamp) + " ms");
            return result;
        }
    }
}

