/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.core.command.executor;

import bsc.api.Enumerations;
import bsc.api.IIdentifiableApiObject;
import bsc.api.basic.container.ObjectContainer;
import bsc.api.basic.container.TYPE;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.commands.GetDevicesCommand;
import bsc.api.transport.result.FailResult;
import bsc.api.transport.result.ObjectResult;
import bsc.api.transport.result.Result;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.core.command.ACoreExecutor;
import bsc.sdk.api.handler.command.Executable;
import bsc.sdk.api.objects.manager.AObjectManager;
import bsc.sdk.api.objects.manager.IObjectManager;
import bsc.sdk.api.objects.manager.ObjectIdentifier;
import bsc.sdk.api.transceiver.controller.impl.TransceiverController;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import bsc.sdk.api.user.session.ISession;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class GetDevicesExecutor
extends ACoreExecutor<GetDevicesCommand> {
    private static Executable<GetDevicesCommand> executable = new CommandExecutor();

    public GetDevicesExecutor(Environment enviromentSettings) {
        super(executable, enviromentSettings);
    }

    public static void setExecutable(Executable<GetDevicesCommand> executable) {
        GetDevicesExecutor.executable = executable;
    }

    public static Executable<GetDevicesCommand> getExecutable() {
        return executable;
    }

    public static class CommandExecutor
    extends Executable<GetDevicesCommand> {
        @Override
        public Result execute(TransceiverIdentifier identifier, GetDevicesCommand command) {
            long startTimestamp = System.currentTimeMillis();
            Environment environment = identifier.getEnvironment();
            TransceiverController controller = identifier.getControllerInstance();
            ISession session = controller.getCurrentSessionID().getObjectInstance();
            UserCredentialIdentifier userCredentialIdentifier = identifier.getUserCredentialIdentifier();
            IObjectManager objectManager = environment.getObjectManager();
            this.logger.trace("Start gathering of objects...");
            Result result = null;
            if (session != null && command.getIDs() != null && !command.getIDs().isEmpty()) {
                HashSet<IIdentifiableApiObject> devices = new HashSet<IIdentifiableApiObject>();
                if (command.isGroupIDs() && objectManager instanceof AObjectManager) {
                    AObjectManager manager = (AObjectManager)objectManager;
                    for (String id : command.getIDs()) {
                        if (id.isEmpty()) {
                            id = "0";
                        }
                        try {
                            devices.addAll(manager.getUserDevicesForGroupID(userCredentialIdentifier, Integer.valueOf(id)));
                        }
                        catch (Exception e) {
                            this.logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                } else {
                    devices.addAll(environment.getObjectManager().getObjectsForUser(userCredentialIdentifier, EnumSet.of(ObjectIdentifier.OBJECT_TYPE.DEVICE), false));
                    Iterator itr = devices.iterator();
                    while (itr.hasNext()) {
                        ADevice device = (ADevice)itr.next();
                        boolean requestedID = false;
                        if (command.isGroupIDs()) {
                            List<Integer> groupIDs = device.getGrpIDs();
                            if (groupIDs != null) {
                                if (groupIDs.isEmpty() && command.getIDs().contains("")) {
                                    requestedID = true;
                                } else {
                                    for (Integer grp : groupIDs) {
                                        if (!command.getIDs().contains(String.valueOf(grp))) continue;
                                        requestedID = true;
                                        break;
                                    }
                                }
                            }
                        } else {
                            boolean bl = requestedID = command.getIDs().contains(device.getDeviceID()) || command.getIDs().contains(device.getClass().getName());
                        }
                        if (command.isExcludeIDs()) {
                            boolean bl = requestedID = !requestedID;
                        }
                        if (requestedID) continue;
                        itr.remove();
                    }
                }
                this.logger.trace(devices.size() + " objects gathered.");
                result = new ObjectResult(new ObjectContainer(TYPE.INCREMENTAL, (Collection<IIdentifiableApiObject>)devices));
            } else {
                result = new FailResult(Enumerations.ErrorType.NO_RESULT);
            }
            this.logger.trace("Gathering objects for group takes: " + (System.currentTimeMillis() - startTimestamp) + " ms");
            return result;
        }
    }
}

