/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.connections.notification;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.bsc.model.ServerInterface;
import bsc.api.modules.connections.commands.offer.AddConditionCollectionOffer;
import bsc.api.modules.connections.commands.offer.AddConnectionOffer;
import bsc.api.modules.connections.commands.offer.AddExecutorCollectionOffer;
import bsc.api.modules.connections.commands.offer.AddExecutorDeviceOffer;
import bsc.api.modules.connections.commands.offer.AssignExecutorCollectionOffer;
import bsc.api.modules.connections.commands.offer.DeleteConditionCollectionOffer;
import bsc.api.modules.connections.commands.offer.DeleteConnectionOffer;
import bsc.api.modules.connections.commands.offer.DeleteExecutorCollectionOffer;
import bsc.api.modules.connections.commands.offer.ExecuteExecutorCollectionOffer;
import bsc.api.modules.connections.commands.offer.GetConditionCollectionsOffer;
import bsc.api.modules.connections.commands.offer.GetConnectionOffer;
import bsc.api.modules.connections.commands.offer.GetConnectionsOffer;
import bsc.api.modules.connections.commands.offer.GetExecutorCollectionOffer;
import bsc.api.modules.connections.commands.offer.GetExecutorCollectionsOffer;
import bsc.api.modules.connections.commands.offer.GetRunningExecutorCollectionsOffer;
import bsc.api.modules.connections.commands.offer.StopExecutorCollectionOffer;
import bsc.api.modules.connections.commands.offer.ToggleConnectionOffer;
import bsc.api.modules.connections.commands.offer.UpdateConditionCollectionOffer;
import bsc.api.modules.connections.commands.offer.UpdateConnectionOffer;
import bsc.api.modules.connections.commands.offer.UpdateExecutorCollectionOffer;
import bsc.api.modules.timer.model.Timer;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.connections.notification.AConnectionNotification;
import bsc.sdk.api.extension.notification.AObjectNotificationListener;
import bsc.sdk.api.notification.ANotificationExecutor;
import bsc.sdk.api.notification.objects.AddDeviceOffers;
import bsc.sdk.api.user.group.Permission;
import java.util.EnumSet;

public class AddDeviceOffersHandler
extends AConnectionNotification<AddDeviceOffers> {
    private static ANotificationExecutor<AddDeviceOffers> executor = new ANotificationExecutor<AddDeviceOffers>(){

        @Override
        public void execute(AObjectNotificationListener<AddDeviceOffers> parent, AddDeviceOffers object) {
            ADevice device = object.getDevice();
            EnumSet<Permission> permissions = object.getPermissions();
            if (device instanceof ServerInterface) {
                device.addCommandOffer(new GetConditionCollectionsOffer());
                device.addCommandOffer(new GetConnectionOffer());
                device.addCommandOffer(new GetConnectionsOffer());
                device.addCommandOffer(new GetExecutorCollectionOffer());
                device.addCommandOffer(new GetExecutorCollectionsOffer());
                device.addCommandOffer(new GetRunningExecutorCollectionsOffer());
                if (permissions.contains((Object)Permission.CONFIGURE)) {
                    device.addCommandOffer(new AddConditionCollectionOffer());
                    device.addCommandOffer(new AddConnectionOffer());
                    device.addCommandOffer(new AddExecutorCollectionOffer());
                    device.addCommandOffer(new AddExecutorDeviceOffer());
                    device.addCommandOffer(new ToggleConnectionOffer());
                    device.addCommandOffer(new UpdateConditionCollectionOffer());
                    device.addCommandOffer(new UpdateConnectionOffer());
                    device.addCommandOffer(new UpdateExecutorCollectionOffer());
                }
                if (permissions.contains((Object)Permission.DELETE)) {
                    device.addCommandOffer(new DeleteConditionCollectionOffer());
                    device.addCommandOffer(new DeleteConnectionOffer());
                    device.addCommandOffer(new DeleteExecutorCollectionOffer());
                }
                if (permissions.contains((Object)Permission.EXECUTE)) {
                    device.addCommandOffer(new ExecuteExecutorCollectionOffer());
                    device.addCommandOffer(new StopExecutorCollectionOffer());
                }
            } else if (device instanceof Timer) {
                if (permissions.contains((Object)Permission.CONFIGURE)) {
                    device.addCommandOffer(new AssignExecutorCollectionOffer());
                }
            } else if (permissions.contains((Object)Permission.CONFIGURE) && device.getDeviceType().equals((Object)Enumerations.DeviceType.ActorContainer)) {
                device.addCommandOffer(new AssignExecutorCollectionOffer());
            }
        }
    };

    public AddDeviceOffersHandler(Environment enviromentSettings) {
        super(executor, enviromentSettings);
    }

    public static ANotificationExecutor<AddDeviceOffers> getExecutor() {
        return executor;
    }

    public static void setExecutor(ANotificationExecutor<AddDeviceOffers> executor) {
        AddDeviceOffersHandler.executor = executor;
    }
}

