/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.bsc;

import bsc.api.Enumerations;
import bsc.api.modules.IModuleClass;
import bsc.api.modules.bsc.IModuleBSC;
import bsc.api.modules.bsc.commands.ICommandsBSC;
import bsc.api.modules.bsc.commands.offer.IOfferBSC;
import bsc.api.modules.bsc.model.IModelBSC;
import bsc.sdk.api.extension.AExtension;
import bsc.sdk.api.extension.modules.bsc.notification.AddMetaDataHandler;

public class BscExtension
extends AExtension {
    private static boolean enabledByDefault = true;

    public BscExtension() {
        super(Enumerations.EXTENSION_ID.BSC);
        this.setEnabled(enabledByDefault);
        this.addMetaInformationEnumClass(SETTINGS.class);
        this.addMetaInformationEnumClass(AddMetaDataHandler.DETAILS.class);
    }

    public void setOem(int oem) {
        this.putExtensionSetting(SETTINGS.OEM, String.valueOf(oem));
    }

    public int getOem() {
        return this.parseInt(this.getExtensionSetting(SETTINGS.OEM));
    }

    public void setProduct(int product) {
        this.putExtensionSetting(SETTINGS.PRODUCT, String.valueOf(product));
    }

    public int getProduct() {
        return this.parseInt(this.getExtensionSetting(SETTINGS.PRODUCT));
    }

    public void setAlias(String alias) {
        this.putExtensionSetting(SETTINGS.ALIAS, alias);
    }

    public String getAlias() {
        return this.getExtensionSetting(SETTINGS.ALIAS);
    }

    public void setVersion(String version) {
        this.putExtensionSetting(SETTINGS.VERSION, version);
    }

    public String getVersion() {
        return this.getExtensionSetting(SETTINGS.VERSION);
    }

    @Override
    protected void _init() {
    }

    @Override
    protected Class<? extends IModuleClass> getModuleInterfaceClass(IModuleClass.CLASS_TYPE type) {
        switch (type) {
            case COMMANDS: {
                return ICommandsBSC.class;
            }
            case MODEL: {
                return IModelBSC.class;
            }
            case MODULE: {
                return IModuleBSC.class;
            }
            case OFFER: {
                return IOfferBSC.class;
            }
        }
        return null;
    }

    public static boolean isEnabledByDefault() {
        return enabledByDefault;
    }

    public static void setEnabledByDefault(boolean enabledByDefault) {
        BscExtension.enabledByDefault = enabledByDefault;
    }

    @Override
    public void shutdown() {
    }

    public static enum SETTINGS {
        OEM,
        PRODUCT,
        ALIAS,
        VERSION;

    }
}

