/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.manager;

import bsc.api.Enumerations;
import bsc.api.IMetaInformation;
import bsc.api.modules.IModuleClass;
import bsc.sdk.api.AManager;
import bsc.sdk.api.extension.ExtensionIdentifier;
import bsc.sdk.api.extension.IExtension;
import bsc.sdk.api.extension.manager.IExtensionManager;
import bsc.sdk.api.extension.notification.IObjectNotificationListener;
import bsc.sdk.api.handler.IObjectHandler;
import bsc.sdk.api.handler.ObjectHandlerIdentifier;
import bsc.sdk.api.notification.INotification;
import bsc.sdk.api.objects.IObjectProcessor;
import bsc.sdk.api.transceiver.controller.IObjectValidator;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;
import bsc.sdk.tools.Tools;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AExtensionManager
extends AManager<ExtensionIdentifier, IExtension>
implements IExtensionManager {
    protected ConcurrentHashMap<String, Set<TransceiverIdentifier>> extensionSubscriptions = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Set<IObjectNotificationListener>> objectNotificationListener = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, String> supportedExtensionObjects = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, String> extensionMetaInformationEnums = new ConcurrentHashMap();

    private Set<TransceiverIdentifier> getSubscriberList(String id) {
        Set<Object> result = null;
        if (id != null && this.extensionSubscriptions.containsKey(id)) {
            result = this.extensionSubscriptions.get(id);
        }
        if (result == null) {
            result = Collections.newSetFromMap(new ConcurrentHashMap());
        }
        return result;
    }

    @Override
    public boolean register(IExtension extension) {
        if (extension == null || extension.getExtensionId() == null || !extension.isEnabled()) {
            return false;
        }
        String id = extension.getExtensionId();
        if (this.isExtensionRegistered(id)) {
            return false;
        }
        this.logger.trace("++++++++++++++++++++++++++++");
        this.logger.trace("Register extension: " + id);
        this.logger.trace("++++++++++++++++++++++++++++");
        this.addObject(extension);
        if (!this.extensionSubscriptions.containsKey(id)) {
            this.extensionSubscriptions.put(id, this.getSubscriberList(id));
        }
        this.registerSupportedExtensionObjects(extension.getSupportedObjects(), id);
        this.registerMetaInformationEnums(extension.getMetaInformationEnums(), id);
        this.registerObjectNotificationListeners(extension.getObjectListenerSet());
        this.registerObjectHandlers(extension.getObjectHandlerSet());
        this.logger.trace("");
        return true;
    }

    public boolean isExtensionRegistered(String extensionID) {
        ExtensionIdentifier identifier = null;
        try {
            identifier = ExtensionIdentifier.createIdentifierInstance(extensionID, this.getEnvironment());
        }
        catch (URISyntaxException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        if (identifier != null) {
            return this.objects.containsKey(identifier.getFullQualifiedIdentifiableString());
        }
        return false;
    }

    protected void registerSupportedExtensionObjects(Set<Class<? extends IModuleClass>> objects, String extensionId) {
        this.logger.trace("----------------------------");
        this.logger.trace("Register supported objects:");
        for (Class<? extends IModuleClass> clazz : objects) {
            this.logger.trace(clazz.getName());
            this.supportedExtensionObjects.put(clazz.getName(), extensionId);
        }
    }

    protected void registerMetaInformationEnums(Set<Class<?>> enums, String extensionId) {
        this.logger.trace("----------------------------");
        this.logger.trace("Register meta info enums:");
        for (Class<?> clazz : enums) {
            this.logger.trace(clazz.getName());
            this.extensionMetaInformationEnums.put(clazz.getName(), extensionId);
        }
    }

    protected void registerObjectNotificationListeners(Set<IObjectNotificationListener> objectNotificationListeners) {
        this.logger.trace("----------------------------");
        this.logger.trace("Register notification listener:");
        for (IObjectNotificationListener listener : objectNotificationListeners) {
            this.logger.trace(listener.getClass().getName());
            String supportedClass = listener.getSupportedClass().getName();
            Set<IObjectNotificationListener> set = this.objectNotificationListener.get(listener.getSupportedClass().getName());
            if (set == null) {
                set = new HashSet<IObjectNotificationListener>();
                this.objectNotificationListener.put(supportedClass, set);
            }
            set.add(listener);
        }
    }

    protected void registerObjectHandlers(Set<IObjectHandler> objectHandlers) {
        if (objectHandlers != null) {
            this.logger.trace("----------------------------");
            this.logger.trace("Register object handler:");
            for (IObjectHandler handler : objectHandlers) {
                this.logger.trace(handler.getClass().getName());
                if (this.getEnvironment().getHandleManager().registerHandler(handler)) continue;
                this.logger.error("Failed to register handler: " + handler.getURI(this.getEnvironment().getApplicationId(), this.getEnvironment().getHostID()).toString());
            }
        }
    }

    @Override
    public boolean unRegister(IExtension extension) {
        String id = extension.getExtensionId();
        if (this.extensionSubscriptions.containsKey(id)) {
            this.extensionSubscriptions.remove(id);
        }
        this.unRegisterObjectNotificationListeners(extension.getObjectListenerSet());
        this.unRegisterObjectHandlers(extension.getObjectHandlerSet());
        this.unRegisterSupportedExtensionObjects(extension.getSupportedObjects());
        return this.removeObject(this.getIdentifierInstance(extension));
    }

    private void unRegisterSupportedExtensionObjects(Set<Class<? extends IModuleClass>> objects) {
        if (objects != null) {
            for (Class<? extends IModuleClass> clazz : objects) {
                this.supportedExtensionObjects.remove(clazz.getName());
            }
        }
    }

    private void unRegisterObjectHandlers(Set<IObjectHandler> objectHandlers) {
        if (objectHandlers != null) {
            for (IObjectHandler handler : objectHandlers) {
                ObjectHandlerIdentifier identifier = (ObjectHandlerIdentifier)this.getEnvironment().getHandleManager().getIdentifierInstance(handler);
                if (identifier == null) continue;
                identifier.deleteObject();
            }
        }
    }

    private void unRegisterObjectNotificationListeners(Set<IObjectNotificationListener> objectNotificationListeners) {
        if (objectNotificationListeners != null) {
            for (IObjectNotificationListener listener : objectNotificationListeners) {
                String supportedClass = listener.getSupportedClass().getName();
                Set<IObjectNotificationListener> set = this.objectNotificationListener.get(supportedClass);
                if (set == null) continue;
                set.remove(supportedClass);
                if (set.size() != 0) continue;
                this.objectNotificationListener.remove(supportedClass);
            }
        }
    }

    @Override
    public boolean subscribe(String extensionId, TransceiverIdentifier transceiver) {
        return this.extensionSubscriptions.containsKey(extensionId) && this.getSubscriberList(extensionId).add(transceiver);
    }

    @Override
    public boolean subscribe(List<String> extensionIds, TransceiverIdentifier transceiver) {
        boolean result = true;
        for (String id : extensionIds) {
            if (this.subscribe(id, transceiver)) continue;
            result = false;
        }
        return result;
    }

    @Override
    public boolean unSubscribe(String extensionId, TransceiverIdentifier transceiver) {
        return this.extensionSubscriptions.containsKey(extensionId) && this.getSubscriberList(extensionId).remove(transceiver);
    }

    @Override
    public boolean unSubscribe(TransceiverIdentifier transceiver) {
        this.logger.trace("unsubscribe... Identifier[" + transceiver + "]");
        this.logger.trace("actually present Identifiers in Sets:");
        boolean completeSuccess = true;
        for (Set<TransceiverIdentifier> ids : this.extensionSubscriptions.values()) {
            for (TransceiverIdentifier ti : ids) {
                this.logger.trace("Identifier[" + ti + "]");
            }
            if (!ids.contains(transceiver)) continue;
            this.logger.trace("removing [" + transceiver + "]");
            completeSuccess &= ids.remove(transceiver);
        }
        return completeSuccess;
    }

    @Override
    public boolean unSubscribe(List<String> extensionIds, TransceiverIdentifier transceiver) {
        boolean result = true;
        for (String id : extensionIds) {
            if (this.unSubscribe(id, transceiver)) continue;
            result = false;
        }
        return result;
    }

    @Override
    public boolean isSubscribedFor(TransceiverIdentifier transceiver, Enumerations.EXTENSION_ID extensionId) {
        return this.isSubscribedFor(transceiver, extensionId.name());
    }

    @Override
    public boolean isSubscribedFor(TransceiverIdentifier transceiver, String extensionId) {
        if (transceiver != null) {
            return this.getSubscriberList(extensionId).contains(transceiver);
        }
        return false;
    }

    @Override
    public Set<TransceiverIdentifier> getExtensionSubscriber(Enumerations.EXTENSION_ID extensionId) {
        return this.getExtensionSubscriber(extensionId.getId());
    }

    @Override
    public Set<TransceiverIdentifier> getExtensionSubscriber(String extensionId) {
        return new HashSet<TransceiverIdentifier>(this.getSubscriberList(extensionId));
    }

    @Override
    protected void fireNotification(INotification notification) {
        String clazz = notification.getClass().getName();
        Set<IObjectNotificationListener> listeners = this.objectNotificationListener.get(clazz);
        if (listeners != null) {
            this.logger.trace("Fire notification: " + clazz);
            for (IObjectNotificationListener listener : listeners) {
                this.logger.trace("Listener: " + listener.getClass().getName());
                listener.notificationReceived(notification);
            }
        }
    }

    @Override
    public Set<IExtension> getRegisteredExtensions() {
        return new HashSet<IExtension>(this.objects.values());
    }

    @Override
    public void disableAllExtensions() {
        for (IExtension extension : this.objects.values()) {
            extension.setEnabled(false);
        }
    }

    protected void loadDefaultExtensions() {
        List<Class<IExtension>> classes = Tools.getClasses(IExtension.class.getPackage().getName() + ".modules", IExtension.class);
        for (Class<IExtension> clazz : classes) {
            if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) continue;
            try {
                IExtension extension = clazz.newInstance();
                this.logger.trace("###############################################");
                this.logger.trace("Create extension instance: " + extension.getExtensionId());
                this.logger.trace("###############################################");
                this.logger.trace("Initialize extension:");
                extension.init(this.getEnvironment());
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.logger.error("Failed to create instance for: " + clazz.getName(), (Throwable)e);
            }
        }
    }

    @Override
    public IExtension getExtension(Enumerations.EXTENSION_ID extensionId) {
        return this.getExtension(extensionId.getId());
    }

    @Override
    public IExtension getExtension(String extensionId) {
        ExtensionIdentifier identifier = null;
        try {
            identifier = ExtensionIdentifier.createIdentifierInstance(extensionId, this.getEnvironment());
        }
        catch (URISyntaxException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        if (identifier == null) {
            return null;
        }
        return (IExtension)this.objects.get(identifier.getFullQualifiedIdentifiableString());
    }

    @Override
    protected void _init() {
        this.loadDefaultExtensions();
        this.addObjectBusTag(Enumerations.OBJECT_BUS_TAGS.PUBLISH_NOTIFICATION);
    }

    @Override
    protected IExtension getNewObjectInstance(IExtension orgObject) {
        return orgObject;
    }

    @Override
    public Set<TransceiverIdentifier> getSubscribedTransceiver(IModuleClass object) {
        Set<TransceiverIdentifier> tmpResult;
        HashSet<TransceiverIdentifier> result = new HashSet<TransceiverIdentifier>();
        String extensionId = null;
        Class<?> clazz = object.getClass();
        do {
            extensionId = this.supportedExtensionObjects.get(clazz.getName());
            clazz = clazz.getSuperclass();
        } while (extensionId == null && clazz != Object.class);
        if (extensionId != null && (tmpResult = this.getSubscriberList(extensionId)) != null) {
            result.addAll(tmpResult);
        }
        return result;
    }

    @Override
    public String getObjectExtensionID(IModuleClass modelObject) {
        String extensionId = null;
        if (modelObject != null) {
            Class<?> clazz = modelObject.getClass();
            do {
                extensionId = this.supportedExtensionObjects.get(clazz.getName());
                clazz = clazz.getSuperclass();
            } while (extensionId == null && clazz != Object.class);
        }
        return extensionId;
    }

    @Override
    public boolean subscribeForInternalExtensions(TransceiverIdentifier transceiver) {
        boolean result = true;
        for (IExtension extension : this.objects.values()) {
            if (!extension.isInternalExtension() || this.subscribe(extension.getExtensionId(), transceiver)) continue;
            result = false;
        }
        return result;
    }

    @Override
    public Set<String> getSubscriptionList(TransceiverIdentifier transceiver) {
        HashSet<String> result = new HashSet<String>();
        for (IExtension extension : this.getRegisteredExtensions()) {
            if (!this.isSubscribedFor(transceiver, extension.getExtensionId())) continue;
            result.add(extension.getExtensionId());
        }
        return result;
    }

    @Override
    public Set<IObjectProcessor> getObjectProcessorSet() {
        HashSet<IObjectProcessor> result = new HashSet<IObjectProcessor>();
        for (IExtension extension : this.objects.values()) {
            if (!extension.isEnabled()) continue;
            result.addAll(extension.getObjectProcessorSet());
        }
        return result;
    }

    @Override
    public Set<IObjectValidator> getObjectValidatorSet() {
        HashSet<IObjectValidator> result = new HashSet<IObjectValidator>();
        for (IExtension extension : this.objects.values()) {
            if (!extension.isEnabled()) continue;
            result.addAll(extension.getObjectValidatorSet());
        }
        return result;
    }

    @Override
    protected void _shutdown() {
        for (IExtension ext : this.objects.values()) {
            ext.shutdown();
        }
    }

    @Override
    public void objectReceived(String tag, Object object) {
        if (Enumerations.OBJECT_BUS_TAGS.PUBLISH_NOTIFICATION.name().equals(tag) && object instanceof INotification) {
            this.fireNotification((INotification)object);
        }
    }

    @Override
    public String getExtensionMetaInformationFromObject(Enum<?> metaEnum, IMetaInformation metaInfo) {
        Class<?> clazz;
        String extensionID;
        String result = null;
        if (metaEnum != null && (extensionID = this.extensionMetaInformationEnums.get((clazz = metaEnum.getClass()).getName())) != null) {
            result = metaInfo.getMetaInformation(extensionID, metaEnum.name());
        }
        return result;
    }
}

