/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension;

import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.identifier.AIdentifier;
import bsc.sdk.api.extension.IExtension;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Objects;

public class ExtensionIdentifier
extends AIdentifier<IExtension> {
    public static int EXTENSION_ID_PART = 0;
    private final String extensionID = this.getPathPart(EXTENSION_ID_PART);

    public ExtensionIdentifier(URI uri) throws URISyntaxException {
        super(uri);
    }

    public String getExtensionID() {
        return this.extensionID;
    }

    public static URI generateURI(String extensionID, String applicationID, String host) {
        if (extensionID != null && applicationID != null && host != null) {
            try {
                String uriString = IExtension.class.getSimpleName() + "://" + applicationID + "@" + host + "/" + URLEncoder.encode(extensionID, "UTF-8");
                return new URI(uriString);
            }
            catch (UnsupportedEncodingException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static URI generateURI(String extensionID, Environment enviromentSettings) {
        return ExtensionIdentifier.generateURI(extensionID, Objects.requireNonNull(enviromentSettings, "enviromentSettings must not be null!").getApplicationId(), enviromentSettings.getHostID());
    }

    public static ExtensionIdentifier createIdentifierInstance(String extensionID, Environment enviromentSettings) throws URISyntaxException {
        return new ExtensionIdentifier(ExtensionIdentifier.generateURI(extensionID, enviromentSettings));
    }

    public static ExtensionIdentifier createIdentifierInstance(IExtension extension, Environment enviromentSettings) throws URISyntaxException {
        return new ExtensionIdentifier(ExtensionIdentifier.generateURI(Objects.requireNonNull(extension, "userCredential must not be null!").getExtensionId(), enviromentSettings));
    }

    @Override
    public IExtension getObjectInstance() {
        return (IExtension)this.environment.getExtensionManager().getObjectInstance(this);
    }

    @Override
    public boolean deleteObject() {
        return this.environment.getExtensionManager().removeObject(this);
    }

    @Override
    public boolean updateObject(IExtension objectInstance) {
        return false;
    }

    @Override
    public boolean saveObject() {
        return this.environment.getExtensionManager().save(this);
    }
}

