/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.server.transceiver.state;

import bsc.api.Enumerations;
import bsc.api.modules.userconfig.commands.ResetPasswordCommand;
import bsc.api.transport.TransmissionObject;
import bsc.api.transport.commands.ConnectionRequest;
import bsc.api.transport.model.Caps;
import bsc.api.transport.model.Settings;
import bsc.api.transport.result.FailResult;
import bsc.api.transport.result.ObjectResult;
import bsc.api.transport.result.OkResult;
import bsc.api.transport.result.Result;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.extension.modules.userconfig.command.executor.ResetPasswordExecutor;
import bsc.sdk.api.transceiver.ChannelWorker;
import bsc.sdk.api.transceiver.ITransceiver;
import bsc.sdk.api.transceiver.controller.impl.TransceiverController;
import bsc.sdk.api.transceiver.state.AStateInit;
import bsc.sdk.api.transceiver.state.ITransceiverState;
import bsc.sdk.api.transceiver.state.StateConfiguration;
import bsc.sdk.api.transceiver.state.StateFactory;
import bsc.sdk.api.user.credential.IUserCredential;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import bsc.sdk.api.user.session.ISession;
import bsc.sdk.api.user.session.SessionType;
import bsc.sdk.api.user.session.manager.SessionIdentifier;
import java.util.List;

public class StateInit
extends AStateInit {
    private boolean connectionPermitted;
    private Caps serverCaps;
    private boolean createSession = true;
    private Stage currentStage = Stage.DONE;

    public StateInit(StateConfiguration stateSettings) {
        super(stateSettings);
        this.connectionPermitted = stateSettings.isConnectionAllowed();
        this.currentStage = Stage.CREATING_CAPS;
    }

    @Override
    public int getLevel() {
        return 0;
    }

    @Override
    public synchronized ITransceiverState execute() {
        try {
            switch (this.currentStage) {
                default: {
                    return this;
                }
                case CREATING_CAPS: {
                    this.serverCaps = this.getCaps();
                    this.currentStage = Stage.WAITING_FOR_CONNECT_COMMAND;
                    this.identifier.getObjectInstance().getChannelHandler().start();
                    return this;
                }
                case WAITING_FOR_CONNECT_COMMAND: {
                    TransmissionObject transmissionObject = this.controller.nextIncomingTransmission();
                    ResetPasswordCommand resetPasswordCommand = null;
                    try {
                        resetPasswordCommand = (ResetPasswordCommand)this.checkResult(transmissionObject, ResetPasswordCommand.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (resetPasswordCommand != null) {
                        Result result = new ResetPasswordExecutor().execute(this.identifier, resetPasswordCommand);
                        this.controller.write(new TransmissionObject(transmissionObject.getID(), result), ChannelWorker.WriteMode.JSON_PROTOCOL);
                        return StateFactory.getDefaultFactory().createState(new StateConfiguration(StateFactory.TYPE.SERVER, StateFactory.STATE.DISCONNECT, this.identifier, this.environment));
                    }
                    ConnectionRequest connectCommand = (ConnectionRequest)this.checkResult(transmissionObject, ConnectionRequest.class);
                    if (!this.connectionPermitted) {
                        this.controller.write(new TransmissionObject(transmissionObject.getID(), new FailResult(Enumerations.ErrorType.TOO_MANY_CLIENTS, "Too many clients connected")), ChannelWorker.WriteMode.JSON_PROTOCOL);
                        throw new TransceiverException(Enumerations.ErrorType.TOO_MANY_CLIENTS, "Too many clients connected");
                    }
                    String sessionID = connectCommand.getSessionID();
                    if (sessionID == null) {
                        this.createSession = true;
                    } else if (sessionID.equalsIgnoreCase("false")) {
                        this.createSession = false;
                    } else if (sessionID != null) {
                        this.environment.getSessionManager().cleanupSessions();
                        SessionIdentifier sessionIdentifier = this.environment.getSessionManager().getSessionByID(sessionID);
                        ISession session = null;
                        if (sessionIdentifier != null) {
                            session = sessionIdentifier.getObjectInstance();
                        }
                        if (session == null || session.getType().equals((Object)SessionType.PRIVATE)) {
                            this.controller.write(new TransmissionObject(transmissionObject.getID(), new FailResult(Enumerations.ErrorType.SESSION_NOT_FOUND, "No such session")), ChannelWorker.WriteMode.JSON_PROTOCOL);
                            throw new TransceiverException(Enumerations.ErrorType.SESSION_NOT_FOUND, "No such session " + sessionID);
                        }
                        UserCredentialIdentifier userCredentialIdentifier = this.environment.getUserCredentialManager().getUserCredential(session.getUserCredentialID());
                        IUserCredential userCredential = userCredentialIdentifier.getObjectInstance();
                        if (userCredential == null) {
                            this.controller.write(new TransmissionObject(transmissionObject.getID(), new FailResult(Enumerations.ErrorType.NO_SUCH_USER, "No such user")), ChannelWorker.WriteMode.JSON_PROTOCOL);
                            throw new TransceiverException(Enumerations.ErrorType.NO_SUCH_USER, "No such user " + sessionID);
                        }
                        if (!userCredential.isActive()) {
                            this.controller.write(new TransmissionObject(transmissionObject.getID(), new FailResult(Enumerations.ErrorType.USER_NOT_ACTIVATED, "User credential is not activated")), ChannelWorker.WriteMode.JSON_PROTOCOL);
                            throw new TransceiverException(Enumerations.ErrorType.USER_NOT_ACTIVATED, "User credential is not activated");
                        }
                        Caps caps = new Caps();
                        caps.addApiVersion(session.getApiVersion());
                        caps.addCompressionType(session.getCompressionType());
                        caps.addEncryptionType(session.getEncryptionType());
                        caps.addProtocolType(session.getProtocolType());
                        caps.setApiExtensions(session.getApiExtensions());
                        Settings settings = this.checkSettings(transmissionObject, this.serverCaps, caps);
                        this.environment.getExtensionManager().subscribeForInternalExtensions(this.identifier);
                        this.environment.getExtensionManager().subscribe(settings.getApiExtensions(), this.identifier);
                        session.setProtocolType(settings.getProtocol());
                        session.setEncryptionType(settings.getEncryption());
                        session.setCompressionType(settings.getCompression());
                        session.setApiVersion(settings.getApiVersion());
                        session.setApiExtensions(settings.getApiExtensions());
                        session.setLastUsedTimestamp(System.currentTimeMillis());
                        this.controller.initialize(sessionIdentifier);
                        if (!this.environment.getTransceiverManager().hasOpenConnectionSlots((UserCredentialIdentifier)this.environment.getUserCredentialManager().getIdentifierInstance(userCredential))) {
                            if (userCredential.getLastSessionID() != null && session != null && userCredential.getLastSessionID().equals(session.getSessionID())) {
                                List<TransceiverController> controllers = sessionIdentifier.getTransceiverControllers();
                                for (TransceiverController transceiverController : controllers) {
                                    if (this.controller.equals(transceiverController)) continue;
                                    transceiverController.disconnect(true);
                                }
                            } else {
                                this.controller.write(new TransmissionObject(transmissionObject.getID(), new FailResult(Enumerations.ErrorType.USER_ALREADY_CONNECTED, "Connection limit reached for this user")), ChannelWorker.WriteMode.JSON_PROTOCOL);
                                throw new TransceiverException(Enumerations.ErrorType.USER_ALREADY_CONNECTED, "Connection limit reached for this user");
                            }
                        }
                        sessionIdentifier.updateObject(session);
                        userCredential.setLastSessionID(sessionID);
                        this.environment.getUserCredentialManager().updateObject(userCredential, false);
                        this.controller.write(new TransmissionObject(transmissionObject.getID(), new OkResult()), ChannelWorker.WriteMode.JSON_PROTOCOL);
                        this.controller.fireStateChanged(ITransceiver.TransceiverState.READY);
                        return StateFactory.getDefaultFactory().createState(new StateConfiguration(StateFactory.TYPE.SERVER, StateFactory.STATE.WORK, this.identifier, this.environment));
                    }
                    this.controller.write(new TransmissionObject(transmissionObject.getID(), new ObjectResult(this.serverCaps)), ChannelWorker.WriteMode.JSON_PROTOCOL);
                    this.currentStage = Stage.WAITING_FOR_CAPS;
                    return this;
                }
                case WAITING_FOR_CAPS: 
            }
            TransmissionObject transmissionObject = this.controller.nextIncomingTransmission();
            Caps caps = (Caps)this.checkResult(transmissionObject, Caps.class);
            Settings settings = this.checkSettings(transmissionObject, this.serverCaps, caps);
            this.environment.getExtensionManager().subscribe(settings.getApiExtensions(), this.identifier);
            this.createSession &= settings.getEncryption() != Enumerations.EncryptionType.NONE;
            this.controller.write(new TransmissionObject(transmissionObject.getID(), new ObjectResult(settings)), ChannelWorker.WriteMode.JSON_PROTOCOL);
            this.currentStage = Stage.DONE;
            StateConfiguration stateSettings = new StateConfiguration(StateFactory.TYPE.SERVER, StateFactory.STATE.AUTH, this.identifier, this.environment);
            stateSettings.setCreateSession(this.createSession);
            stateSettings.setSettings(settings);
            stateSettings.setMetaInformations(caps.getAllMetaInformations());
            return StateFactory.getDefaultFactory().createState(stateSettings);
        }
        catch (TransceiverException e) {
            return this.error(e);
        }
    }

    @Override
    public ITransceiverState disconnect(boolean terminate) {
        return StateFactory.getDefaultFactory().createState(new StateConfiguration(StateFactory.TYPE.SERVER, StateFactory.STATE.DISCONNECT, this.identifier, this.environment));
    }

    @Override
    public ITransceiverState error(TransceiverException exception) {
        return StateFactory.getDefaultFactory().createState(new StateConfiguration(StateFactory.TYPE.SERVER, StateFactory.STATE.ERROR, this.identifier, this.environment));
    }

    private Settings checkSettings(TransmissionObject transmissionObject, Caps serverCaps, Caps caps) throws TransceiverException {
        Enumerations.EncryptionType encryptionType = Caps.getPreferredType(serverCaps.getEncryptions(), caps.getEncryptions());
        if (encryptionType == null) {
            this.controller.write(new TransmissionObject(transmissionObject.getID(), new FailResult(Enumerations.ErrorType.UNKNOWN_ENCRYPTION, "The encryptions are not supported")), ChannelWorker.WriteMode.JSON_PROTOCOL);
            throw new TransceiverException(Enumerations.ErrorType.UNKNOWN_ENCRYPTION, "The selected encryptions are not supported");
        }
        Enumerations.ProtocolType protocolType = Caps.getPreferredType(serverCaps.getProtocols(), caps.getProtocols());
        if (protocolType == null) {
            this.controller.write(new TransmissionObject(transmissionObject.getID(), new FailResult(Enumerations.ErrorType.UNKNOWN_PROTOCOL, "The protocols are not supported")), ChannelWorker.WriteMode.JSON_PROTOCOL);
            throw new TransceiverException(Enumerations.ErrorType.UNKNOWN_PROTOCOL, "The selected protocols are not supported");
        }
        Enumerations.CompressionType compressionType = Caps.getPreferredType(serverCaps.getCompressions(), caps.getCompressions());
        if (compressionType == null) {
            this.controller.write(new TransmissionObject(transmissionObject.getID(), new FailResult(Enumerations.ErrorType.UNKNOWN_COMPRESSION, "The compressions are not supported")), ChannelWorker.WriteMode.JSON_PROTOCOL);
            throw new TransceiverException(Enumerations.ErrorType.UNKNOWN_COMPRESSION, "The selected compressions are not supported");
        }
        Enumerations.ApiVersion apiVersion = Caps.getPreferredType(serverCaps.getApiVersions(), caps.getApiVersions());
        if (apiVersion == null) {
            this.controller.write(new TransmissionObject(transmissionObject.getID(), new FailResult(Enumerations.ErrorType.UNSUPPORTED_API_VERSION, "The api versions are not supported")), ChannelWorker.WriteMode.JSON_PROTOCOL);
            throw new TransceiverException(Enumerations.ErrorType.UNSUPPORTED_API_VERSION, "The selected api versions are not supported");
        }
        List<String> apiExtensions = Caps.getPreferredList(serverCaps.getApiExtensions(), caps.getApiExtensions());
        if (apiExtensions == null) {
            this.controller.write(new TransmissionObject(transmissionObject.getID(), new FailResult(Enumerations.ErrorType.UNSUPPORTED_API_VERSION, "The api extensions are not supported")), ChannelWorker.WriteMode.JSON_PROTOCOL);
            throw new TransceiverException(Enumerations.ErrorType.UNSUPPORTED_API_VERSION, "The selected api extensions are not supported");
        }
        Settings settings = new Settings(protocolType, compressionType, encryptionType, apiVersion, apiExtensions);
        return settings;
    }

    private static enum Stage {
        CREATING_CAPS,
        WAITING_FOR_CONNECT_COMMAND,
        WAITING_FOR_CAPS,
        DONE;

    }
}

