/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.server;

import bsc.api.Enumerations;
import bsc.sdk.api.application.AApplication;
import bsc.sdk.api.application.IServer;
import bsc.sdk.api.application.builder.Product;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.environment.EnvironmentBuilder;
import bsc.sdk.api.application.environment.settings.ServerSettings;
import bsc.sdk.api.application.idpool.IdPool;
import bsc.sdk.api.application.manager.IApplicationManager;
import bsc.sdk.api.application.server.IServerChannel;
import bsc.sdk.api.extension.manager.IExtensionManager;
import bsc.sdk.api.handler.manager.IHandleManager;
import bsc.sdk.api.objects.manager.IObjectManager;
import bsc.sdk.api.transceiver.ChannelWorker;
import bsc.sdk.api.transceiver.ITransceiver;
import bsc.sdk.api.transceiver.TransceiverFactory;
import bsc.sdk.api.transceiver.listener.ITransceiverListener;
import bsc.sdk.api.transceiver.manager.ITransceiverManager;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;
import bsc.sdk.api.transceiver.manager.TransceiverManagerFactory;
import bsc.sdk.api.transceiver.state.StateConfiguration;
import bsc.sdk.api.transceiver.state.StateFactory;
import bsc.sdk.api.transceiver.transmission.manager.ITransmissionManager;
import bsc.sdk.api.user.credential.manager.IUserCredentialManager;
import bsc.sdk.api.user.group.manager.IUserGroupManager;
import bsc.sdk.api.user.session.manager.ISessionManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;

public class Server
extends AApplication
implements IServer {
    protected static final String serverChennelSequencePoolName = "ServerChannelSequence_";
    private int port;
    private boolean serving;
    private String serverAddress;
    private Set<ITransceiverListener> transceiverListeners;
    private IServerChannel serverChannel;
    private IdPool channelIdPool;

    protected Server() {
    }

    protected Server(Server server) {
        this.channelIdPool = server.channelIdPool;
        this.port = server.getPort();
        this.serving = server.isServing();
        this.serverAddress = server.getServerAddress();
        this.setEnvironment(server.getEnvironment());
        this.setApplicationId(server.getApplicationId());
        this.setApplicationManager(server.getApplicationManager());
        this.setApplicationHost(server.getApplicationHost());
    }

    @Override
    public void run() {
        while (this.serving) {
            try {
                ITransceiver transceiver = null;
                this.logger.debug("Waiting for clients:");
                ChannelWorker handler = this.serverChannel.accept();
                if (handler == null) continue;
                this.logger.debug("Client connected; building transceiver...");
                transceiver = TransceiverFactory.createNewInstance(handler, this.getEnvironment(), null);
                for (ITransceiverListener iTransceiverListener : this.getTransceiverListeners()) {
                    transceiver.addTransceiverListener(iTransceiverListener);
                }
                this.logger.debug("contacting client...");
                ITransceiverManager transceiverManager = this.getEnvironment().getTransceiverManager();
                transceiverManager.stateChanged(transceiver, ITransceiver.TransceiverState.CONNECTED);
                StateConfiguration stateSettings = new StateConfiguration(StateFactory.TYPE.SERVER, StateFactory.STATE.INIT, (TransceiverIdentifier)transceiverManager.getIdentifierInstance(transceiver), this.getEnvironment());
                stateSettings.setConnectionAllowed(this.environment.getTransceiverManager().hasOpenConnectionSlots());
                transceiver.setTransceiverState(StateFactory.getDefaultFactory().createState(stateSettings));
                transceiver.connect();
            }
            catch (Exception e) {
                if (!this.isShutdownInProgress()) {
                    this.fireStateChanged(IApplicationManager.ApplicationState.UNEXPECTED_SHUTDOWN);
                }
                this.logger.error(e.getMessage(), (Throwable)e);
                this.setServing(false);
            }
        }
    }

    public Server serve() {
        this.start();
        while (!this.serving && this.isAlive()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return this;
    }

    public void addTransceiverListeners(Set<ITransceiverListener> transceiverListeners) {
        this.getTransceiverListeners().addAll(transceiverListeners);
    }

    public void addTransceiverListener(ITransceiverListener transceiverListener) {
        this.getTransceiverListeners().add(transceiverListener);
    }

    public Set<ITransceiverListener> getTransceiverListeners() {
        return this.transceiverListeners;
    }

    void setTransceiverListeners(Set<ITransceiverListener> transceiverListeners) {
        this.transceiverListeners = transceiverListeners;
    }

    public IServerChannel getServerChannel() {
        return this.serverChannel;
    }

    void setServerChannel(IServerChannel serverChannel) {
        this.serverChannel = serverChannel;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public int getPort() {
        return this.port;
    }

    void setPort(int port) {
        this.port = port;
    }

    public boolean isServing() {
        return this.serving;
    }

    void setServing(boolean serving) {
        this.serving = serving;
    }

    void setChannelIdPool(IdPool idPool) {
        this.channelIdPool = idPool;
    }

    public IHandleManager getHandleManager() {
        return this.getEnvironment().getHandleManager();
    }

    public IExtensionManager getExtensionManager() {
        return this.getEnvironment().getExtensionManager();
    }

    public IUserCredentialManager getUserCredentialManager() {
        return this.getEnvironment().getUserCredentialManager();
    }

    public IUserGroupManager getUserGroupManager() {
        return this.getEnvironment().getUserGroupManager();
    }

    public ITransceiverManager getTransceiverManager() {
        return this.getEnvironment().getTransceiverManager();
    }

    public IObjectManager getObjectManager() {
        return this.getEnvironment().getObjectManager();
    }

    public ISessionManager getSessionManager() {
        return this.getEnvironment().getSessionManager();
    }

    public ITransmissionManager getTransmissionManager() {
        return this.getEnvironment().getTransmissionManager();
    }

    @Override
    protected void _shutdown() {
        try {
            this.getServerChannel().close();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Environment getEnvironment() {
        if (this.environment == null) {
            ServerSettings settings = new ServerSettings(Arrays.asList(Enumerations.ProtocolType.JSON), Arrays.asList(Enumerations.EncryptionType.AES, Enumerations.EncryptionType.NONE), Arrays.asList(Enumerations.CompressionType.DEFLATE, Enumerations.CompressionType.NONE), Arrays.asList(Enumerations.ApiVersion.Ver_2_1_0), 1, 1);
            this.environment = Product.create(EnvironmentBuilder.class).setTransceiverManagerFactory(TransceiverManagerFactory.getDefaultFactory()).setApplicationManager(this.getApplicationManager()).setApplicationId(this.getApplicationId()).setApplicationName(this.getApplicationName()).setHostID(this.getApplicationHost()).setApplicationSettings(settings).buildProduct();
        }
        return this.environment;
    }
}

