/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.server;

import bsc.sdk.api.application.builder.IBuilder;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.environment.EnvironmentRegistry;
import bsc.sdk.api.application.environment.settings.ServerSettings;
import bsc.sdk.api.application.executors.DynamicScheduledCachedThreadPoolExecutor;
import bsc.sdk.api.application.manager.IApplicationManager;
import bsc.sdk.api.application.server.IServerChannel;
import bsc.sdk.api.application.server.Server;
import bsc.sdk.api.transceiver.listener.ITransceiverListener;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AServerBuilder<T extends AServerBuilder<?>>
implements IBuilder<Server> {
    private static Logger logger = LoggerFactory.getLogger(AServerBuilder.class);
    private Server server = new Server();
    private int maxGlobalConnectionSlots = 1;
    private int maxUserConnectionSlots = 1;

    public AServerBuilder() {
        this.server.setPort(2021);
        this.server.setServing(false);
        this.server.setServerAddress("0.0.0.0");
        this.server.setApplicationHost("local");
    }

    abstract IServerChannel createServerSocketChannel(String var1, int var2, ExecutorService var3) throws IOException;

    private Set<ITransceiverListener> createDefaultTransceiverListeners() {
        Set<ITransceiverListener> listeners = Collections.newSetFromMap(new ConcurrentHashMap());
        return listeners;
    }

    public T setPort(int port) {
        if (port > 0) {
            this.server.setPort(port);
        }
        return (T)this;
    }

    public T setServing(boolean serving) {
        this.server.setServing(serving);
        return (T)this;
    }

    public T setServerAddress(String serverAddress) {
        this.server.setServerAddress(serverAddress);
        return (T)this;
    }

    public T setTransceiverListeners(Set<ITransceiverListener> transceiverListeners) {
        this.server.setTransceiverListeners(transceiverListeners);
        return (T)this;
    }

    public T setEnvironment(Environment environment) {
        this.server.setEnvironment(environment);
        return (T)this;
    }

    public T setApplicationName(String applicationName) {
        this.server.setApplicationName(applicationName);
        return (T)this;
    }

    public T setApplicationHost(String applicationHost) {
        this.server.setApplicationHost(applicationHost);
        return (T)this;
    }

    public T setMaxGlobalConnectionSlots(int maxSlots) {
        this.maxGlobalConnectionSlots = maxSlots;
        return (T)this;
    }

    public T setMaxUserConnectionSlots(int maxSlots) {
        this.maxUserConnectionSlots = maxSlots;
        return (T)this;
    }

    public T setApplicationManager(IApplicationManager applicationManager) {
        this.server.setApplicationManager(applicationManager);
        this.server.setApplicationId(applicationManager.generateApplicationId());
        return (T)this;
    }

    @Override
    public Server buildProduct() {
        Server newServer = new Server(this.server);
        try {
            Environment envSettings = newServer.getEnvironment();
            DynamicScheduledCachedThreadPoolExecutor executorService = newServer.getExecutorServiceIoPriority();
            newServer.setServerChannel(this.createServerSocketChannel(this.server.getServerAddress(), this.server.getPort(), executorService));
            if (newServer.getTransceiverListeners() == null) {
                newServer.setTransceiverListeners(this.createDefaultTransceiverListeners());
                newServer.getTransceiverListeners().add(newServer.getTransceiverManager());
            }
            ServerSettings settings = (ServerSettings)envSettings.getSettings();
            settings.setMaxGlobalConnectionSlots(this.maxGlobalConnectionSlots);
            settings.setMaxUserConnectionSlots(this.maxUserConnectionSlots);
            EnvironmentRegistry.registerEnvironment(envSettings);
            envSettings.getApplicationManager().addObject(newServer);
            envSettings.getIdPoolManager().init(envSettings);
            newServer.getHandleManager().init(envSettings);
            newServer.getExtensionManager().init(envSettings);
            newServer.getUserCredentialManager().init(envSettings);
            newServer.getSessionManager().init(envSettings);
            newServer.getUserGroupManager().init(envSettings);
            newServer.getObjectManager().init(envSettings);
            newServer.getTransmissionManager().init(envSettings);
            newServer.getTransceiverManager().init(envSettings);
            newServer.setServing(true);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            newServer.setServing(false);
        }
        return newServer;
    }
}

