/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.manager;

import bsc.sdk.api.application.manager.ApplicationManager;
import bsc.sdk.api.application.manager.IApplicationManager;

public abstract class ApplicationManagerFactory {
    private static ApplicationManagerFactory defaultFactory = null;

    public static ApplicationManagerFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = ApplicationManagerFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(ApplicationManagerFactory factory) {
        defaultFactory = factory;
    }

    public static ApplicationManagerFactory createDefaultFactory() {
        return new ApplicationManagerFactory(){

            @Override
            public IApplicationManager createInstance() {
                return new ApplicationManager();
            }
        };
    }

    public static IApplicationManager createNewInstance() {
        return ApplicationManagerFactory.getDefaultFactory().createInstance();
    }

    public abstract IApplicationManager createInstance();
}

