/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.environment;

import bsc.api.Enumerations;
import bsc.sdk.api.application.builder.IBuilder;
import bsc.sdk.api.application.environment.ApplicationSettings;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.idpool.IdPoolManager;
import bsc.sdk.api.application.manager.IApplicationManager;
import bsc.sdk.api.extension.manager.AExtensionManagerFactory;
import bsc.sdk.api.handler.manager.HandleManagerFactory;
import bsc.sdk.api.objects.manager.ObjectManagerFactory;
import bsc.sdk.api.transceiver.manager.TransceiverManagerFactory;
import bsc.sdk.api.transceiver.transmission.manager.TransmissionManagerFactory;
import bsc.sdk.api.user.credential.manager.AUserCredentialManagerFactory;
import bsc.sdk.api.user.group.manager.UserGroupManagerFactory;
import bsc.sdk.api.user.session.manager.ASessionManagerFactory;
import java.util.Arrays;
import java.util.List;

public class EnvironmentBuilder
implements IBuilder<Environment> {
    private Environment environment = new Environment();

    public EnvironmentBuilder() {
        this.initIdPoolManager();
        this.initExtensionManager();
        this.initHandleManager();
        this.initUserCredentialManager();
        this.initUserGroupManager();
        this.initSessionManager();
        this.initTransceiverManager();
        this.initObjectManager();
        this.initTransmissionManager();
        this.initApplicationSettings(new ApplicationSettings(Arrays.asList(Enumerations.ProtocolType.JSON), Arrays.asList(Enumerations.EncryptionType.AES, Enumerations.EncryptionType.NONE), Arrays.asList(Enumerations.CompressionType.DEFLATE, Enumerations.CompressionType.NONE), Arrays.asList(Enumerations.ApiVersion.Ver_2_1_0, Enumerations.ApiVersion.Ver_3_1_0)));
        this.initHostID("local");
    }

    private void initApplicationSettings(ApplicationSettings settings) {
        this.environment.setSettings(settings);
    }

    private void initHandleManager() {
        this.environment.setHandleManager(HandleManagerFactory.createNewInstance());
    }

    private void initUserCredentialManager() {
        this.environment.setUserCredentialManager(AUserCredentialManagerFactory.createNewInstance());
    }

    private void initUserGroupManager() {
        this.environment.setUserGroupManager(UserGroupManagerFactory.createNewInstance());
    }

    private void initSessionManager() {
        this.environment.setSessionManager(ASessionManagerFactory.createNewInstance());
    }

    private void initTransceiverManager() {
        this.environment.setTransceiverManager(TransceiverManagerFactory.createNewInstance());
    }

    private void initObjectManager() {
        this.environment.setObjectManager(ObjectManagerFactory.createNewInstance());
    }

    private void initExtensionManager() {
        this.environment.setExtensionManager(AExtensionManagerFactory.createNewInstance());
    }

    private void initIdPoolManager() {
        this.environment.setIdPoolManager(new IdPoolManager());
    }

    private void initTransmissionManager() {
        this.environment.setTransmissionManager(TransmissionManagerFactory.createNewInstance());
    }

    private void initProtocols(List<Enumerations.ProtocolType> protocols) {
        this.environment.getSettings().setProtocols(protocols);
    }

    private void initEncryptions(List<Enumerations.EncryptionType> encryptions) {
        this.environment.getSettings().setEncryptions(encryptions);
    }

    private void initCompressions(List<Enumerations.CompressionType> compressions) {
        this.environment.getSettings().setCompressions(compressions);
    }

    private void initApiVersions(List<Enumerations.ApiVersion> apiVersions) {
        this.environment.getSettings().setApiVersions(apiVersions);
    }

    private void initHostID(String hostID) {
        this.environment.setHostID(hostID);
    }

    public EnvironmentBuilder setApplicationSettings(ApplicationSettings settings) {
        this.initApplicationSettings(settings);
        return this;
    }

    public EnvironmentBuilder setProtocols(List<Enumerations.ProtocolType> protocols) {
        this.initProtocols(protocols);
        return this;
    }

    public EnvironmentBuilder setEncryptions(List<Enumerations.EncryptionType> encryptions) {
        this.initEncryptions(encryptions);
        return this;
    }

    public EnvironmentBuilder setCompressions(List<Enumerations.CompressionType> compressions) {
        this.initCompressions(compressions);
        return this;
    }

    public EnvironmentBuilder setApiVersions(List<Enumerations.ApiVersion> apiVersions) {
        this.initApiVersions(apiVersions);
        return this;
    }

    public EnvironmentBuilder setHandleManagerFactory(HandleManagerFactory handleManagerFactory) {
        HandleManagerFactory.setDefaultFactory(handleManagerFactory);
        this.initHandleManager();
        return this;
    }

    public EnvironmentBuilder setUserCredentialManagerFactory(AUserCredentialManagerFactory userCredentialManagerFactory) {
        AUserCredentialManagerFactory.setDefaultFactory(userCredentialManagerFactory);
        this.initUserCredentialManager();
        return this;
    }

    public EnvironmentBuilder setUserGroupManagerFactory(UserGroupManagerFactory userGroupManagerFactory) {
        UserGroupManagerFactory.setDefaultFactory(userGroupManagerFactory);
        this.initUserGroupManager();
        return this;
    }

    public EnvironmentBuilder setSessionManagerFactory(ASessionManagerFactory sessionManagerFactory) {
        ASessionManagerFactory.setCurrentFactory(sessionManagerFactory);
        this.initSessionManager();
        return this;
    }

    public EnvironmentBuilder setTransceiverManagerFactory(TransceiverManagerFactory transceiverManagerFactory) {
        TransceiverManagerFactory.setDefaultFactory(transceiverManagerFactory);
        this.initTransceiverManager();
        return this;
    }

    public EnvironmentBuilder setObjectManagerFactory(ObjectManagerFactory objectManagerFactory) {
        ObjectManagerFactory.setDefaultFactory(objectManagerFactory);
        this.initObjectManager();
        return this;
    }

    public EnvironmentBuilder setExtensionManagerFactory(AExtensionManagerFactory extensionManagerFactory) {
        AExtensionManagerFactory.setDefaultFactory(extensionManagerFactory);
        this.initExtensionManager();
        return this;
    }

    public EnvironmentBuilder setApplicationId(String applicationId) {
        this.environment.setApplicationId(applicationId);
        return this;
    }

    public EnvironmentBuilder setApplicationName(String applicationName) {
        this.environment.setApplicationName(applicationName);
        return this;
    }

    public EnvironmentBuilder setHostID(String hostID) {
        this.environment.setHostID(hostID);
        return this;
    }

    public EnvironmentBuilder setApplicationManager(IApplicationManager applicationManager) {
        this.environment.setApplicationManager(applicationManager);
        return this;
    }

    @Override
    public Environment buildProduct() {
        return new Environment(this.environment);
    }
}

