/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.client.transceiver.state;

import bsc.api.Enumerations;
import bsc.api.transport.TransmissionObject;
import bsc.api.transport.model.Auth;
import bsc.api.transport.model.Settings;
import bsc.sdk.api.crypt.CipherFactory;
import bsc.sdk.api.crypt.ICipher;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.transceiver.ChannelWorker;
import bsc.sdk.api.transceiver.ITransceiver;
import bsc.sdk.api.transceiver.state.AStateInit;
import bsc.sdk.api.transceiver.state.ITransceiverState;
import bsc.sdk.api.transceiver.state.StateConfiguration;
import bsc.sdk.api.transceiver.state.StateFactory;
import bsc.sdk.api.user.credential.IUserCredential;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import bsc.sdk.api.user.session.ISession;
import bsc.sdk.api.user.session.manager.SessionIdentifier;
import bsc.sdk.security.Checksum;
import bsc.sdk.security.DHKey;
import bsc.sdk.tools.SimpleFileWriter;
import bsc.sdk.tools.Tools;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateAuth
extends AStateInit {
    private static Logger logger = LoggerFactory.getLogger(StateAuth.class);
    private ISession session;
    private Settings settings;
    private BigInteger a;
    private Stage currentStage = Stage.DONE;

    public StateAuth(StateConfiguration stateSettings) {
        super(stateSettings);
        this.session = stateSettings.getSession();
        this.currentStage = Stage.SENDING_AUTHENTICATION;
    }

    @Override
    public int getLevel() {
        return 1;
    }

    @Override
    public ITransceiverState execute() {
        try {
            SessionIdentifier sessionIdentifier;
            switch (this.currentStage) {
                default: {
                    return this;
                }
                case SENDING_AUTHENTICATION: {
                    ICipher cipher;
                    UserCredentialIdentifier userCredentialIdentifier;
                    TransmissionObject transmissionObject = this.controller.nextIncomingTransmission();
                    this.settings = (Settings)this.checkResult(transmissionObject, Settings.class);
                    this.environment.getExtensionManager().subscribeForInternalExtensions(this.identifier);
                    this.environment.getExtensionManager().subscribe(this.settings.getApiExtensions(), this.identifier);
                    try {
                        userCredentialIdentifier = UserCredentialIdentifier.createIdentifierInstance(this.session.getUserCredentialID(), this.getEnvironment());
                    }
                    catch (URISyntaxException e1) {
                        throw new TransceiverException(Enumerations.ErrorType.EXCEPTION, (Throwable)e1);
                    }
                    IUserCredential userCredential = userCredentialIdentifier.getObjectInstance();
                    try {
                        String password = userCredential.getPassword();
                        byte[] hash = Checksum.getSHA256Checksum(password.getBytes("UTF-8"));
                        String passwordHash = Tools.toHexString(hash);
                        String combined = userCredential.getUserName() + passwordHash;
                        cipher = CipherFactory.createNewInstance(Enumerations.EncryptionType.AES);
                        cipher.setShared(combined.getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new TransceiverException(Enumerations.ErrorType.EXCEPTION, (Throwable)e);
                    }
                    this.a = DHKey.genertateRandom(new SecureRandom(), DHKey.BitSize.SIZE_2048);
                    BigInteger A = DHKey.genertatePublic(this.a, DHKey.BitSize.SIZE_2048);
                    byte[] publicKey = A.toByteArray();
                    byte[] checksum = Checksum.getSHA256Checksum(publicKey);
                    byte[] signature = cipher.encrypt(checksum);
                    Auth auth = new Auth(userCredential.getUserName(), publicKey, signature);
                    this.controller.write(new TransmissionObject(this.getNewTransmissionId(), auth), false, ChannelWorker.WriteMode.JSON_PROTOCOL);
                    this.currentStage = Stage.WAITING_FOR_AUTHENTICATION;
                    return this;
                }
                case WAITING_FOR_AUTHENTICATION: 
            }
            TransmissionObject transmissionObject = this.controller.nextIncomingTransmission();
            byte[] sharedSecret = null;
            Auth auth = (Auth)this.checkResult(transmissionObject, Auth.class);
            byte[] B = auth.getKey();
            BigInteger shared = DHKey.genertateShared(new BigInteger(1, B), this.a, DHKey.BitSize.SIZE_2048);
            String sharedSecretString = shared.toString(16);
            sharedSecret = Tools.getBytes(sharedSecretString);
            String sessionID = auth.getSessionID();
            try {
                sessionIdentifier = SessionIdentifier.createIdentifierInstance(sessionID, this.getEnvironment());
            }
            catch (URISyntaxException e) {
                throw new TransceiverException(Enumerations.ErrorType.EXCEPTION, (Throwable)e);
            }
            if (sessionID == null) {
                this.session.setSessionID(null);
                this.session.setSharedSecret(null);
            } else {
                UserCredentialIdentifier userCredentialIdentifier;
                logger.trace("Create new session: " + sessionID);
                this.session.setSessionID(sessionID);
                this.session.setSharedSecret(sharedSecret);
                this.session.setApiVersion(this.settings.getApiVersion());
                this.session.setCompressionType(this.settings.getCompression());
                this.session.setEncryptionType(this.settings.getEncryption());
                this.session.setProtocolType(this.settings.getProtocol());
                this.session.setApiExtensions(this.settings.getApiExtensions());
                this.session.setCapsMetaData(this.getCapsMetaData());
                this.session.setLastUsedTimestamp(System.currentTimeMillis());
                this.session.setTimestamp(System.currentTimeMillis());
                ((SessionIdentifier)this.environment.getSessionManager().addObject(this.session)).saveObject();
                try {
                    userCredentialIdentifier = UserCredentialIdentifier.createIdentifierInstance(this.session.getUserCredentialID(), this.getEnvironment());
                }
                catch (URISyntaxException e) {
                    throw new TransceiverException(Enumerations.ErrorType.EXCEPTION, (Throwable)e);
                }
                IUserCredential userCredential = userCredentialIdentifier.getObjectInstance();
                userCredential.setLastSessionID(sessionIdentifier.getSessionID());
                this.environment.getUserCredentialManager().updateObject(userCredential, false);
            }
            this.controller.initialize(sessionIdentifier);
            this.controller.fireStateChanged(ITransceiver.TransceiverState.READY);
            this.currentStage = Stage.DONE;
            return StateFactory.getDefaultFactory().createState(new StateConfiguration(StateFactory.TYPE.CLIENT, StateFactory.STATE.WORK, this.identifier, this.environment));
        }
        catch (TransceiverException e) {
            return this.error(e);
        }
    }

    private void logDataPartOne(BigInteger A, BigInteger a) {
        String log = "\r\n";
        log = log + "---- Connection ---- \r\n";
        log = log + "client PubKey:  \r\n";
        log = log + Tools.toHexString(A.toByteArray()) + "\r\n";
        log = log + "\r\n";
        log = log + "client PrivKey: \r\n";
        log = log + Tools.toHexString(a.toByteArray()) + "\r\n";
        log = log + "\r\n";
        SimpleFileWriter.writeTo(StateAuth.class.getName() + "_" + this.getEnvironment().getApplicationId() + ".txt", log);
    }

    private void logDataPartTwo(byte[] sharedSecret, byte[] B) {
        String log = "\r\n";
        log = log + "sharedSecret:   \r\n";
        log = log + Tools.toHexString(sharedSecret) + "\r\n";
        log = log + "\r\n";
        log = log + "server PubKey:  \r\n";
        log = log + Tools.toHexString(B) + "\r\n";
        log = log + "\r\n";
        log = log + "--------------------------\r\n";
        SimpleFileWriter.writeTo(StateAuth.class.getName() + "_" + this.getEnvironment().getApplicationId() + ".txt", log);
    }

    @Override
    public ITransceiverState disconnect(boolean terminate) {
        return StateFactory.getDefaultFactory().createState(new StateConfiguration(StateFactory.TYPE.CLIENT, StateFactory.STATE.DISCONNECT, this.identifier, this.environment));
    }

    @Override
    public ITransceiverState error(TransceiverException exception) {
        StateConfiguration stateSettings = new StateConfiguration(StateFactory.TYPE.CLIENT, StateFactory.STATE.ERROR, this.identifier, this.environment);
        stateSettings.setThrowable(exception);
        return StateFactory.getDefaultFactory().createState(stateSettings);
    }

    private static enum Stage {
        SENDING_AUTHENTICATION,
        WAITING_FOR_AUTHENTICATION,
        DONE;

    }
}

