/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.client;

import bsc.sdk.api.application.client.AClientBuilder;
import bsc.sdk.api.transceiver.ChannelHandler;
import bsc.sdk.api.transceiver.ChannelWorker;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientBuilderAsync
extends AClientBuilder<ClientBuilderAsync> {
    private static Logger logger = LoggerFactory.getLogger(ClientBuilderAsync.class);

    @Override
    ChannelWorker createChannelWorker(String serverAddress, int port, ExecutorService executorService) {
        ChannelHandler worker = null;
        try {
            AsynchronousSocketChannel clientChannel = AsynchronousSocketChannel.open();
            worker = new ChannelHandler(clientChannel, executorService);
            clientChannel.connect(new InetSocketAddress(serverAddress, port));
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return worker;
    }
}

