/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.client;

import bsc.api.IApiObject;
import bsc.api.IIdentifiable;
import bsc.api.basic.commands.Command;
import bsc.sdk.api.application.AApplication;
import bsc.sdk.api.application.IClient;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.extension.manager.IExtensionManager;
import bsc.sdk.api.handler.manager.IHandleManager;
import bsc.sdk.api.objects.manager.IObjectManager;
import bsc.sdk.api.transceiver.ChannelWorker;
import bsc.sdk.api.transceiver.ITransceiver;
import bsc.sdk.api.transceiver.TransceiverFactory;
import bsc.sdk.api.transceiver.listener.ITransceiverListener;
import bsc.sdk.api.transceiver.manager.ITransceiverManager;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;
import bsc.sdk.api.transceiver.state.StateConfiguration;
import bsc.sdk.api.transceiver.state.StateFactory;
import bsc.sdk.api.transceiver.transmission.FutureTransmission;
import bsc.sdk.api.transceiver.transmission.manager.ITransmissionManager;
import bsc.sdk.api.user.credential.AUserCredentialFactory;
import bsc.sdk.api.user.credential.IUserCredential;
import bsc.sdk.api.user.credential.manager.IUserCredentialManager;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import bsc.sdk.api.user.group.manager.IUserGroupManager;
import bsc.sdk.api.user.session.ASessionFactory;
import bsc.sdk.api.user.session.ISession;
import bsc.sdk.api.user.session.manager.ISessionManager;
import bsc.sdk.api.user.session.manager.SessionIdentifier;
import bsc.sdk.net.ISocket;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Client
extends AApplication
implements IClient {
    private int port;
    private String user;
    private String password;
    private String server;
    protected ITransceiver transceiver = null;
    private TransceiverIdentifier transceiverIdentifier = null;
    private ISocket iSocket = null;
    protected Set<ITransceiverListener> transceiverListeners = null;
    protected ChannelWorker channelWorker;

    protected Client() {
    }

    protected Client(Client client) {
        this.user = client.getUser();
        this.password = client.getPassword();
        this.server = client.getServer();
        this.port = client.getPort();
        this.setApplicationManager(client.getApplicationManager());
        this.setApplicationId(client.getApplicationId());
        this.setApplicationHost(client.getApplicationHost());
    }

    @Override
    public Client connect() {
        if (this.transceiver == null) {
            this.setTransceiver(TransceiverFactory.createNewInstance(this.getChannelWorker(), this.getEnvironment(), null));
        }
        ITransceiverManager transceiverManager = this.getEnvironment().getTransceiverManager();
        transceiverManager.stateChanged(this.getTransceiver(), ITransceiver.TransceiverState.CONNECTED);
        this.initEnviromentSettings();
        if (this.transceiverListeners == null) {
            this.getTransceiverListeners().add(this.getEnvironment().getTransceiverManager());
        }
        for (ITransceiverListener iTransceiverListener : this.getTransceiverListeners()) {
            this.getTransceiver().addTransceiverListener(iTransceiverListener);
        }
        this.getTransceiver().connect();
        return this;
    }

    protected void initEnviromentSettings() {
        UserCredentialIdentifier userCredentialIdentifier = this.getEnvironment().getUserCredentialManager().getUserCredential(this.getUser());
        IUserCredential userCredential = null;
        if (userCredentialIdentifier != null) {
            userCredential = userCredentialIdentifier.getObjectInstance();
        }
        if (userCredential == null) {
            userCredential = AUserCredentialFactory.createNewInstance(this.getUser(), this.getPassword());
            userCredentialIdentifier = (UserCredentialIdentifier)this.getEnvironment().getUserCredentialManager().addObject(userCredential);
            this.getEnvironment().getUserCredentialManager().save(userCredentialIdentifier);
        } else {
            userCredential.setPassword(this.getPassword());
            this.getEnvironment().getUserCredentialManager().save(userCredentialIdentifier);
        }
        String lastSessionID = userCredential.getLastSessionID();
        ISession lastSession = null;
        if (lastSessionID == null) {
            lastSession = ASessionFactory.createNewInstance();
            lastSession.setUserCredentialID(userCredentialIdentifier.getUserCredentialID());
        } else {
            SessionIdentifier lastSessionIdentifier = null;
            try {
                lastSessionIdentifier = SessionIdentifier.createIdentifierInstance(lastSessionID, this.getEnvironment());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (lastSessionIdentifier != null && (lastSession = lastSessionIdentifier.getObjectInstance()) == null) {
                lastSession = ASessionFactory.createNewInstance();
                lastSession.setUserCredentialID(userCredentialIdentifier.getUserCredentialID());
            }
        }
        ITransceiverManager transceiverManager = this.getEnvironment().getTransceiverManager();
        TransceiverIdentifier identifier = (TransceiverIdentifier)transceiverManager.getIdentifierInstance(this.getTransceiver());
        StateConfiguration stateSettings = new StateConfiguration(StateFactory.TYPE.CLIENT, StateFactory.STATE.INIT, identifier, this.getEnvironment());
        stateSettings.setSession(lastSession);
        this.getTransceiver().setTransceiverState(StateFactory.getDefaultFactory().createState(stateSettings));
    }

    @Override
    public ISession getSession() {
        UserCredentialIdentifier userCredentialIdentifier = this.getUserCredential();
        if (userCredentialIdentifier == null) {
            return null;
        }
        IUserCredential userCredential = userCredentialIdentifier.getObjectInstance();
        if (userCredential == null) {
            return null;
        }
        SessionIdentifier lastSessionIdentifier = null;
        try {
            lastSessionIdentifier = SessionIdentifier.createIdentifierInstance(userCredential.getLastSessionID(), this.getEnvironment());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (lastSessionIdentifier == null) {
            return null;
        }
        return (ISession)this.getEnvironment().getSessionManager().getObjectInstance(lastSessionIdentifier);
    }

    public ChannelWorker getChannelWorker() {
        return this.channelWorker;
    }

    void setChannelWorker(ChannelWorker channelWorker) {
        this.channelWorker = channelWorker;
    }

    public String getUser() {
        return Objects.requireNonNull(this.user, "user must not be null");
    }

    void setUser(String user) {
        this.user = Objects.requireNonNull(user, "user must not be null");
    }

    public String getPassword() {
        return Objects.requireNonNull(this.password, "password must not be null");
    }

    void setPassword(String password) {
        this.password = Objects.requireNonNull(password, "password must not be null");
    }

    public String getServer() {
        return this.server;
    }

    void setServer(String server) {
        this.server = Objects.requireNonNull(server, "server must not be null");
    }

    public int getPort() {
        return this.port;
    }

    void setPort(int port) {
        this.port = port;
    }

    public ITransceiver getTransceiver() {
        return Objects.requireNonNull(this.transceiver, "transceiver must not be null");
    }

    public Client setTransceiver(ITransceiver transceiver) {
        this.transceiver = Objects.requireNonNull(transceiver, "transceiver must not be null");
        return this;
    }

    public Set<ITransceiverListener> getTransceiverListeners() {
        if (this.transceiverListeners == null) {
            this.transceiverListeners = new HashSet<ITransceiverListener>();
        }
        return this.transceiverListeners;
    }

    public Client setTransceiverListeners(Set<ITransceiverListener> transceiverListener) {
        this.transceiverListeners = Objects.requireNonNull(transceiverListener, "transceiverListner must not be null");
        return this;
    }

    public Client addTransceiverListener(ITransceiverListener transceiverListener) {
        this.getTransceiverListeners().add(transceiverListener);
        return this;
    }

    public Client setSession(ISession session) {
        this.getEnvironment().getSessionManager().addObject((IIdentifiable)Objects.requireNonNull(session, "session must not be null"));
        return this;
    }

    public UserCredentialIdentifier getUserCredential() {
        UserCredentialIdentifier userCredential = this.getEnvironment().getUserCredentialManager().getUserCredential(this.getUser());
        return Objects.requireNonNull(userCredential, "userCredential must not be null");
    }

    public Client setUserCredential(IUserCredential userCredential) {
        this.getEnvironment().getUserCredentialManager().addObject((IIdentifiable)Objects.requireNonNull(userCredential, "userCredential must not be null"));
        return this;
    }

    public ISocket getiSocket() {
        return Objects.requireNonNull(this.iSocket, "iSocket must not be null");
    }

    public Client setiSocket(ISocket iSocket) {
        this.iSocket = Objects.requireNonNull(iSocket, "iSocket must not be null");
        return this;
    }

    public IHandleManager getHandleManager() {
        return this.getEnvironment().getHandleManager();
    }

    public IExtensionManager getExtensionManager() {
        return this.getEnvironment().getExtensionManager();
    }

    public ISessionManager getSessionManager() {
        return this.getEnvironment().getSessionManager();
    }

    public IObjectManager getObjectManager() {
        return this.getEnvironment().getObjectManager();
    }

    public IUserCredentialManager getUserCredentialManager() {
        return this.getEnvironment().getUserCredentialManager();
    }

    public IUserGroupManager getUserGroupManager() {
        return this.getEnvironment().getUserGroupManager();
    }

    public ITransmissionManager getTransmissionManager() {
        return this.getEnvironment().getTransmissionManager();
    }

    @Override
    public IClient disconnect() {
        this.getTransceiver().disconnect(true);
        return null;
    }

    @Override
    public FutureTransmission sendCommand(Command command) throws TransceiverException {
        return this.getTransceiverIdentifier().sendCommand(command);
    }

    @Override
    public FutureTransmission sendObject(IApiObject object) throws TransceiverException {
        return this.getTransceiverIdentifier().sendObject(object);
    }

    public ITransceiverManager getTransceiverManager() {
        return this.getEnvironment().getTransceiverManager();
    }

    @Override
    protected void _shutdown() {
    }

    public TransceiverIdentifier getTransceiverIdentifier() {
        if (this.transceiverIdentifier == null) {
            this.transceiverIdentifier = (TransceiverIdentifier)this.getEnvironment().getTransceiverManager().getIdentifierInstance(this.getTransceiver());
        }
        return this.transceiverIdentifier;
    }

    @Override
    public ITransceiver.TransceiverState getConnectionState() {
        ITransceiver.TransceiverState result = ITransceiver.TransceiverState.DISCONNECTED;
        if (this.transceiver != null) {
            result = this.transceiver.getState();
        }
        return result;
    }
}

