/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.client;

import bsc.api.Enumerations;
import bsc.sdk.api.application.builder.IBuilder;
import bsc.sdk.api.application.client.Client;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.environment.EnvironmentRegistry;
import bsc.sdk.api.application.manager.IApplicationManager;
import bsc.sdk.api.extension.manager.IExtensionManager;
import bsc.sdk.api.extension.modules.m2m.M2MExtension;
import bsc.sdk.api.transceiver.ChannelWorker;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

abstract class AClientBuilder<T extends AClientBuilder<?>>
implements IBuilder<Client> {
    private Client client = new Client();
    private String m2mVID;

    public AClientBuilder() {
        this.client.setPort(2021);
        this.client.setUser("");
        this.client.setPassword("");
        this.client.setServer("127.0.0.1");
        this.client.setApplicationHost("local");
    }

    abstract ChannelWorker createChannelWorker(String var1, int var2, ExecutorService var3);

    public T setPort(int port) {
        if (port > 0) {
            this.client.setPort(port);
        }
        return (T)this;
    }

    public T setUser(String user) {
        this.client.setUser(Objects.requireNonNull(user, "user must nor be null"));
        return (T)this;
    }

    public T setPassword(String password) {
        this.client.setPassword(Objects.requireNonNull(password, "password must not be null"));
        return (T)this;
    }

    public T setServer(String server) {
        this.client.setServer(Objects.requireNonNull(server, "server must not be null"));
        return (T)this;
    }

    public T setApplicationManager(IApplicationManager applicationManager) {
        this.client.setApplicationManager(applicationManager);
        this.client.setApplicationId(applicationManager.generateApplicationId());
        return (T)this;
    }

    public T setApplicationName(String applicationName) {
        this.client.setApplicationName(applicationName);
        return (T)this;
    }

    public T setM2MConnectID(String m2mConnectID) {
        this.m2mVID = m2mConnectID;
        return (T)this;
    }

    public T setApplicationHost(String applicationHost) {
        this.client.setApplicationHost(applicationHost);
        return (T)this;
    }

    @Override
    public Client buildProduct() {
        IExtensionManager extensionManager;
        M2MExtension m2mExtension;
        Client newClient = new Client(this.client);
        ChannelWorker handler = this.createChannelWorker(newClient.getServer(), newClient.getPort(), newClient.getExecutorServiceIoPriority());
        if (handler == null) {
            throw new RuntimeException("ChannelWorker couldn't be created");
        }
        newClient.setChannelWorker(handler);
        Environment envSettings = newClient.getEnvironment();
        EnvironmentRegistry.registerEnvironment(envSettings);
        envSettings.getApplicationManager().addObject(newClient);
        envSettings.getIdPoolManager().init(envSettings);
        newClient.getHandleManager().init(envSettings);
        newClient.getExtensionManager().init(envSettings);
        newClient.getUserCredentialManager().init(envSettings);
        newClient.getSessionManager().init(envSettings);
        newClient.getObjectManager().init(envSettings);
        newClient.getUserGroupManager().init(envSettings);
        newClient.getTransmissionManager().init(envSettings);
        newClient.getTransceiverManager().init(envSettings);
        if (this.m2mVID != null && (m2mExtension = (M2MExtension)(extensionManager = envSettings.getExtensionManager()).getExtension(Enumerations.EXTENSION_ID.M2M)) != null && m2mExtension.isEnabled()) {
            m2mExtension.setVID(this.m2mVID);
        }
        return newClient;
    }
}

