/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api;

import bsc.api.Enumerations;
import bsc.api.IIdentifiable;
import bsc.api.IUpdateableObject;
import bsc.sdk.api.AIdentifierCache;
import bsc.sdk.api.IManager;
import bsc.sdk.api.application.IObjectListener;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.identifier.IIdentifier;
import bsc.sdk.api.notification.INotification;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AManager<T extends IIdentifier<O>, O extends IIdentifiable>
extends AIdentifierCache<T, O>
implements IManager<T, O>,
IObjectListener {
    protected Map<String, O> objects = new ConcurrentHashMap<String, O>();
    protected Set<String> objectBusTags = new HashSet<String>();

    @Override
    public void init(Environment environment) {
        super.init(environment);
        this._init();
        if (!this.objectBusTags.isEmpty()) {
            environment.getApplication().registerObjectListener(this);
        }
    }

    protected void addObjectBusTag(String tag) {
        if (tag != null) {
            this.objectBusTags.add(tag);
        }
    }

    protected void addObjectBusTag(Enum<?> tagEnum) {
        if (tagEnum != null) {
            this.objectBusTags.add(tagEnum.name());
        }
    }

    protected boolean registerObjectBus() {
        boolean result;
        boolean bl = result = !this.objectBusTags.isEmpty();
        if (result) {
            this.environment.getApplication().registerObjectListener(this);
        }
        return result;
    }

    protected void unregisterObjectBus() {
        this.environment.getApplication().removeObjectListener(this);
    }

    @Override
    public void shutdown() {
        this._shutdown();
        this.unregisterObjectBus();
        super.shutdown();
    }

    @Override
    protected Class<T> getIdentifierClass() {
        ParameterizedType type = this.searchForSuperParameterizedType(this.getClass());
        Type arg = type.getActualTypeArguments()[0];
        return (Class)arg;
    }

    @Override
    protected Class<O> getObjectClass() {
        ParameterizedType type = this.searchForSuperParameterizedType(this.getClass());
        Type arg = type.getActualTypeArguments()[1];
        return (Class)arg;
    }

    private ParameterizedType searchForSuperParameterizedType(Class<?> clazz) {
        Type genericSuperclass = clazz.getGenericSuperclass();
        while (!(genericSuperclass instanceof ParameterizedType) || ((ParameterizedType)genericSuperclass).getRawType() != AManager.class) {
            if (genericSuperclass instanceof ParameterizedType) {
                genericSuperclass = ((Class)((ParameterizedType)genericSuperclass).getRawType()).getGenericSuperclass();
                continue;
            }
            genericSuperclass = ((Class)genericSuperclass).getGenericSuperclass();
        }
        return (ParameterizedType)genericSuperclass;
    }

    @Override
    public T addObject(O object) {
        this.cacheCleanerActive = false;
        Object identifier = this.getIdentifierInstance((IIdentifiable)Objects.requireNonNull(object, "object must not be null!"));
        if (identifier != null && identifier.getObjectInstance() == null) {
            this.logger.trace("Add Object:" + identifier.getFullQualifiedIdentifiableString());
            this.objects.put(identifier.getFullQualifiedIdentifiableString(), object);
        }
        this.cacheCleanerActive = true;
        return identifier;
    }

    @Override
    public Collection<T> addObject(Collection<O> object) {
        HashSet<T> result = new HashSet<T>();
        for (IIdentifiable o : object) {
            result.add(this.addObject(o));
        }
        return result;
    }

    @Override
    public O getObjectInstance(T objectIdentifier) {
        if (objectIdentifier == null) {
            return null;
        }
        IIdentifiable result = (IIdentifiable)this.objects.get(objectIdentifier.getFullQualifiedIdentifiableString());
        return (O)result;
    }

    @Override
    public List<O> getObjectInstances() {
        Collection<O> values = this.objects.values();
        ArrayList<IIdentifiable> result = new ArrayList<IIdentifiable>();
        for (IIdentifiable value : values) {
            IIdentifiable clonedValue = this.getNewObjectInstance(value);
            if (clonedValue == null) continue;
            result.add(clonedValue);
        }
        return result;
    }

    @Override
    public boolean removeObject(T objectIdentifier) {
        this.logger.trace("Remove object: " + objectIdentifier.getFullQualifiedIdentifiableString());
        this.removeIdentifier(objectIdentifier.getURI());
        return this.objects.remove(objectIdentifier.getFullQualifiedIdentifiableString()) != null;
    }

    @Override
    public boolean updateObject(IUpdateableObject object) {
        IIdentifiable orgObject;
        Object identifier;
        if (object instanceof IUpdateableObject && (identifier = this.getIdentifierInstance((IIdentifiable)((Object)object))) != null && (orgObject = (IIdentifiable)this.objects.get(identifier.getFullQualifiedIdentifiableString())) != null) {
            if (object.equals(orgObject)) {
                this.save(identifier);
                return true;
            }
            try {
                IUpdateableObject updateable = (IUpdateableObject)((Object)orgObject);
                if (updateable.updateObject(object)) {
                    this.save(identifier);
                    return true;
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    protected void fireNotification(INotification notification) {
        if (this.environment != null) {
            this.environment.getApplication().publishObject(Enumerations.OBJECT_BUS_TAGS.PUBLISH_NOTIFICATION, (Object)notification);
        }
    }

    protected abstract void _init();

    protected abstract void _shutdown();

    protected abstract O getNewObjectInstance(O var1);

    @Override
    public boolean clearObjectPool() {
        this.objects.clear();
        this.identifierCache.clear();
        return this.objects.isEmpty();
    }

    @Override
    public Set<String> getTags() {
        return this.objectBusTags;
    }

    protected void publishObject(Enum<?> tag, Object object) {
        if (this.environment != null) {
            this.environment.getApplication().publishObject(tag, object);
        }
    }
}

