/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.modules.timer.model;

import bsc.api.Enumerations;
import bsc.api.IUpdateableObject;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.timer.model.IModelTimer;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Timer
extends ADevice
implements IModelTimer {
    private static final long serialVersionUID = 5047204886430406844L;
    private boolean enabled = false;
    private MODE mode = null;
    private String time = "0";
    private int offset = 0;
    private TYPE type = null;
    private int period = 0;
    private int selectedDays = 0;
    private boolean visible = false;
    String sunrise = null;
    String sunset = null;

    public Timer(String timerID) {
        super(Enumerations.DeviceType.Timer);
        this.setName(Enumerations.SensorName.Timer.name());
        this.setDeviceID(timerID);
    }

    public Timer(Timer timer) {
        this.updateObject(timer);
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public int getSelectedDays() {
        return this.selectedDays;
    }

    public void setSelectedDays(int selectedDays) {
        this.selectedDays = selectedDays;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public List<Enumerations.DAYS> getSelectedDaysList() {
        return Timer.getSeletedDaysList(this.selectedDays);
    }

    public static List<Enumerations.DAYS> getSeletedDaysList(int selectedIntValue) {
        ArrayList<Enumerations.DAYS> list = new ArrayList<Enumerations.DAYS>();
        for (Enumerations.DAYS day : Enumerations.DAYS.values()) {
            if ((selectedIntValue >> day.ordinal() & 1) == 0) continue;
            list.add(day);
        }
        return list;
    }

    public static int getIntegerSelectedDayValue(List<Enumerations.DAYS> selectedDays) {
        int value = 0;
        if (selectedDays != null) {
            for (Enumerations.DAYS day : selectedDays) {
                value |= 1 << day.ordinal();
            }
        }
        return value;
    }

    public boolean isDaySelected(Enumerations.DAYS day) {
        return (this.selectedDays >> day.ordinal() & 1) != 0;
    }

    public void setSelectedDays(List<Enumerations.DAYS> selectedDays) {
        this.setSelectedDays(Timer.getIntegerSelectedDayValue(selectedDays));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public MODE getMode() {
        return this.mode;
    }

    public void setMode(MODE mode) {
        this.mode = mode;
    }

    public TYPE getType() {
        return this.type;
    }

    public void setType(TYPE type) {
        this.type = type;
    }

    public String getSunrise() {
        return this.sunrise;
    }

    public void setSunrise(String sunrise) {
        this.sunrise = sunrise;
    }

    public String getSunset() {
        return this.sunset;
    }

    public void setSunset(String sunset) {
        this.sunset = sunset;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public String toString() {
        String className = this.getClass().getSimpleName();
        String formatedTime = new SimpleDateFormat("dd.MM.yyyy HH:mm").format(new Date(Long.valueOf(this.time)));
        StringBuilder sb = new StringBuilder();
        List<Enumerations.DAYS> sd = this.getSelectedDaysList();
        boolean first = true;
        for (Enumerations.DAYS day : sd) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(day.name());
        }
        String formatedSelectedDays = sb.toString();
        return MessageFormat.format("{0}: deviceType: {1}, deviceID = {2}, grpID = {3}, state = {4}, name={5} enabled = {6}, mode = {7}, time = {9} ({11}), offset = {10}, type = {11}, period = {12}, selectedDays = {13} ({14}), sunrise = {15}, sunset = {16}, visible = {17}", new Object[]{className, this.deviceType, this.deviceID, this.getGrpIDs(), this.state, this.name, this.enabled, this.mode, this.time, formatedTime, this.offset, this.type, this.period, this.selectedDays, formatedSelectedDays, this.sunrise, this.sunset, this.visible});
    }

    @Override
    public boolean updateObject(IUpdateableObject objectInstance) {
        if (objectInstance instanceof Timer) {
            if (!super.updateObject(objectInstance)) {
                return false;
            }
            Timer timer = (Timer)objectInstance;
            this.setEnabled(timer.isEnabled());
            this.setMode(timer.getMode());
            this.setType(timer.getType());
            this.setTime(timer.getTime());
            this.setOffset(timer.getOffset());
            this.setPeriod(timer.getPeriod());
            this.setSelectedDays(timer.getSelectedDays());
            this.setSunrise(timer.getSunrise());
            this.setSunset(timer.getSunset());
            this.setVisible(timer.isVisible());
            return true;
        }
        return false;
    }

    @Override
    public boolean dataEquals(IUpdateableObject objectInstance) {
        boolean equal = objectInstance instanceof Timer;
        if (equal) {
            Timer timer = (Timer)objectInstance;
            equal &= super.dataEquals(objectInstance);
            equal &= timer.enabled == this.enabled;
            equal &= timer.mode == null ? this.mode == null : timer.mode.equals((Object)this.mode);
            equal &= timer.time.equals(this.time);
            equal &= timer.offset == this.offset;
            equal &= timer.type == null ? this.type == null : timer.type.equals((Object)this.type);
            equal &= timer.period == this.period;
            equal &= timer.selectedDays == this.selectedDays;
            equal &= timer.sunrise == null ? this.sunrise == null : timer.sunrise.equals(this.sunrise);
            equal &= timer.sunset == null ? this.sunset == null : timer.sunset.equals(this.sunset);
            equal &= timer.visible == this.visible;
        }
        return equal;
    }

    public static enum TYPE {
        ONCE,
        DAILY,
        WEEKLY,
        MONTHLY,
        YEARLY,
        SELECTED_DAYS,
        PERIODIC;

    }

    public static enum MODE {
        NORMAL,
        SUNRISE,
        SUNSET;

    }
}

