/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.modules.teachin.referenceid;

import bsc.api.Enumerations;
import bsc.api.modules.teachin.referenceid.AFRISO;
import bsc.api.modules.teachin.referenceid.BSC;
import bsc.api.modules.teachin.referenceid.EEP;
import bsc.api.modules.teachin.referenceid.ELERO;
import bsc.api.modules.teachin.referenceid.ELTAKO;
import bsc.api.modules.teachin.referenceid.ENOCEAN;
import bsc.api.modules.teachin.referenceid.EUROTRONIC;
import bsc.api.modules.teachin.referenceid.GenericDevice;
import bsc.api.modules.teachin.referenceid.HOPPE;
import bsc.api.modules.teachin.referenceid.IDRF;
import bsc.api.modules.teachin.referenceid.IQFY;
import bsc.api.modules.teachin.referenceid.IReferenceID;
import bsc.api.modules.teachin.referenceid.KP;
import bsc.api.modules.teachin.referenceid.MACO;
import bsc.api.modules.teachin.referenceid.MSR;
import bsc.api.modules.teachin.referenceid.OVENTROP;
import bsc.api.modules.teachin.referenceid.REHAU;
import bsc.api.modules.teachin.referenceid.ROTO_FRANK;
import bsc.api.modules.teachin.referenceid.SERVODAN;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReferenceIDs {
    public static final Class<?>[] includedClasses;

    public static IReferenceID getReferenceIDbyString(String referenceID) {
        IReferenceID result = null;
        if (referenceID == null) {
            return result;
        }
        if (referenceID.contains("bsc")) {
            result = BSC.getByReferenceId(referenceID);
        } else if (referenceID.contains("iroom")) {
            result = BSC.getByReferenceId(referenceID);
        } else if (referenceID.contains("eltako")) {
            result = ELTAKO.getByReferenceId(referenceID);
        } else if (referenceID.contains("afriso")) {
            result = AFRISO.getByReferenceId(referenceID);
        } else if (referenceID.contains("iqfy")) {
            result = IQFY.getByReferenceId(referenceID);
        } else if (referenceID.contains("kp")) {
            result = KP.getByReferenceId(referenceID);
        } else if (referenceID.contains("eurotronic")) {
            result = EUROTRONIC.getByReferenceId(referenceID);
        } else if (referenceID.contains("msr")) {
            result = MSR.getByReferenceId(referenceID);
        } else if (referenceID.contains("servodan")) {
            result = SERVODAN.getByReferenceId(referenceID);
        } else if (referenceID.contains("maco")) {
            result = MACO.getByReferenceId(referenceID);
        } else if (referenceID.contains("eep")) {
            result = EEP.getByReferenceId(referenceID);
        } else if (referenceID.contains("generic")) {
            result = GenericDevice.getByReferenceId(referenceID);
        } else if (referenceID.contains("hoppe")) {
            result = HOPPE.getByReferenceId(referenceID);
        } else if (referenceID.contains("elero")) {
            result = ELERO.getByReferenceId(referenceID);
        } else if (referenceID.contains("idrf")) {
            result = IDRF.getByReferenceId(referenceID);
        } else if (referenceID.contains("oventrop")) {
            result = OVENTROP.getByReferenceId(referenceID);
        } else if (referenceID.contains("rehau")) {
            result = REHAU.getByReferenceId(referenceID);
        } else if (referenceID.contains("rotofrank")) {
            result = ROTO_FRANK.getByReferenceId(referenceID);
        } else if (referenceID.contains("enocean")) {
            result = ENOCEAN.getByReferenceId(referenceID);
        } else {
            for (Class<?> c : includedClasses) {
                if (!IReferenceID.class.isAssignableFrom(c)) continue;
                try {
                    Method m = c.getMethod("getByReferenceId", String.class);
                    result = (IReferenceID)m.invoke(null, new Object[]{new String[]{referenceID}});
                }
                catch (ClassCastException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    // empty catch block
                }
                if (result != null) break;
            }
        }
        return result;
    }

    static {
        for (Class<?> f : includedClasses = new Class[]{AFRISO.class, BSC.class, EEP.class, ELTAKO.class, ENOCEAN.class, EUROTRONIC.class, GenericDevice.class, HOPPE.class, IDRF.class, IQFY.class, KP.class, MACO.class, MSR.class, SERVODAN.class, OVENTROP.class, REHAU.class, ROTO_FRANK.class, ELERO.class}) {
            if (!IReferenceID.class.isAssignableFrom(f)) continue;
            f.getEnumConstants();
        }
    }

    public static class SensorEntry {
        private final String name;
        private final String type;

        public SensorEntry(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public SensorEntry(Enumerations.SensorName sensorName) {
            this.name = sensorName == null ? null : sensorName.name();
            this.type = sensorName == null ? null : sensorName.getType().name();
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return "SensorEntry [name=" + this.name + ", type=" + this.type + "]";
        }
    }
}

