/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.modules.teachin.referenceid;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ISensor;
import bsc.api.modules.teachin.referenceid.IReferenceID;
import bsc.api.modules.teachin.referenceid.ReferenceIDs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum EUROTRONIC implements IReferenceID
{
    STELLA_E("enocean.eurotronic.stella-e", null, Arrays.asList("default"), null, Enumerations.SensorName.SetPoint, Enumerations.SensorName.Temperature, Enumerations.SensorName.Valve, Enumerations.SensorName.Window, Enumerations.SensorName.Battery);

    private final String id;
    private final ArrayList<ReferenceIDs.SensorEntry> sensorIndex = new ArrayList();
    private final List<String> teachInNames;
    private final List<String> acknowledgeNames;
    private final IReferenceID superType;
    private final Set<IReferenceID> subTypes = new HashSet<IReferenceID>();

    private EUROTRONIC(String id, List<String> teachInNames, List<String> acknowledgeNames, IReferenceID superType, Enumerations.SensorName ... sensorNames) {
        this(id, teachInNames, acknowledgeNames, superType);
        if (sensorNames != null) {
            for (Enumerations.SensorName sensorName : sensorNames) {
                this.sensorIndex.add(new ReferenceIDs.SensorEntry(sensorName));
            }
        }
    }

    private EUROTRONIC(String id, List<String> teachInNames, List<String> acknowledgeNames, IReferenceID superType) {
        this.id = id;
        this.superType = superType;
        if (this.superType != null) {
            this.superType.registerSubType(this);
        }
        this.teachInNames = teachInNames;
        this.acknowledgeNames = acknowledgeNames;
    }

    public String toString() {
        return this.id;
    }

    public static EUROTRONIC getByReferenceId(String referenceId) {
        for (EUROTRONIC value : EUROTRONIC.values()) {
            if (!value.getReferenceId().equalsIgnoreCase(referenceId)) continue;
            return value;
        }
        return null;
    }

    @Override
    public void registerSubType(IReferenceID subType) {
        if (subType != null) {
            this.subTypes.add(subType);
        }
    }

    @Override
    public Set<IReferenceID> getSubTypes() {
        return Collections.unmodifiableSet(this.subTypes);
    }

    @Override
    public ISensor getMainSensor(ADevice device) {
        return device.getSensorByName(this.getSensorName(0));
    }

    @Override
    public String getSensorName(int index) {
        if (index >= this.sensorIndex.size()) {
            return null;
        }
        ReferenceIDs.SensorEntry entry = this.sensorIndex.get(index);
        return entry == null ? null : entry.getName();
    }

    @Override
    public ArrayList<ReferenceIDs.SensorEntry> getSensorIndex() {
        ArrayList<ReferenceIDs.SensorEntry> result = new ArrayList<ReferenceIDs.SensorEntry>();
        result.addAll(this.sensorIndex);
        return result;
    }

    @Override
    public String getReferenceId() {
        return this.id;
    }

    @Override
    public List<String> getTeachInNames() {
        List<String> result = null;
        if (this.teachInNames != null) {
            result = Collections.unmodifiableList(this.teachInNames);
        }
        return result;
    }

    @Override
    public List<String> getAcknowledgeNames() {
        List<String> result = null;
        if (this.acknowledgeNames != null) {
            result = Collections.unmodifiableList(this.acknowledgeNames);
        }
        return result;
    }

    @Override
    public IReferenceID getSuperType() {
        return this.superType;
    }
}

