/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.modules.teachin.referenceid;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ISensor;
import bsc.api.modules.teachin.referenceid.GenericDevice;
import bsc.api.modules.teachin.referenceid.IReferenceID;
import bsc.api.modules.teachin.referenceid.ReferenceIDs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum ENOCEAN implements IReferenceID
{
    EDWS("enocean.enocean.edws", null, Arrays.asList("default"), null, Enumerations.SensorName.Open),
    EKCS("enocean.enocean.ekcs", null, Arrays.asList("default"), null, Enumerations.SensorName.CardSwitch),
    ETHSA("enocean.enocean.ethsa", Arrays.asList("default"), Arrays.asList("default"), null, Enumerations.SensorName.Temperature, Enumerations.SensorName.Humidity),
    EasyFit_D2_14_41("enocean.enocean.easyfit_d2_14_41", Arrays.asList("default"), Arrays.asList("default"), null, Enumerations.SensorName.Temperature, Enumerations.SensorName.Humidity, Enumerations.SensorName.Brightness, Enumerations.SensorName.Open, Enumerations.SensorName.Acceleration_State, Enumerations.SensorName.Acceleration_X, Enumerations.SensorName.Acceleration_Y, Enumerations.SensorName.Acceleration_Z),
    EasyFit_D2_14_40("enocean.enocean.easyfit_d2_14_40", Arrays.asList("default"), Arrays.asList("default"), null, Enumerations.SensorName.Temperature, Enumerations.SensorName.Humidity, Enumerations.SensorName.Brightness, Enumerations.SensorName.Acceleration_State, Enumerations.SensorName.Acceleration_X, Enumerations.SensorName.Acceleration_Y, Enumerations.SensorName.Acceleration_Z),
    EasyFit_A5_14_05("enocean.enocean.easyfit_a5_14_05", Arrays.asList("default"), Arrays.asList("default"), null, Enumerations.SensorName.Battery, Enumerations.SensorName.Detection),
    EasyFit_A5_04_01("enocean.enocean.easyfit_a5_04_01", Arrays.asList("default"), Arrays.asList("default"), null, Enumerations.SensorName.Humidity, Enumerations.SensorName.Temperature),
    EasyFit_D5_00_01("enocean.enocean.easyfit_d5_00_01", Arrays.asList("default"), Arrays.asList("default"), null, Enumerations.SensorName.Open),
    EasyFit_A5_02_05("enocean.enocean.easyfit_a5-02-05", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    EasyFit_A5_06_02("enocean.enocean.easyfit_a5-06-02", null, Arrays.asList("default"), GenericDevice.BRIGHTNESS, Enumerations.SensorName.Brightness, Enumerations.SensorName.Voltage),
    EasyFit_A5_06_03("enocean.enocean.easyfit_a5-06-03", null, Arrays.asList("default"), GenericDevice.BRIGHTNESS, Enumerations.SensorName.Brightness, Enumerations.SensorName.Voltage);

    private final String id;
    private final ArrayList<ReferenceIDs.SensorEntry> sensorIndex = new ArrayList();
    private final List<String> teachInNames;
    private final List<String> acknowledgeNames;
    private final IReferenceID superType;
    private final Set<IReferenceID> subTypes = new HashSet<IReferenceID>();

    private ENOCEAN(String id, List<String> teachInNames, List<String> acknowledgeNames, IReferenceID superType, Enumerations.SensorName ... sensorNames) {
        this(id, teachInNames, acknowledgeNames, superType);
        if (sensorNames != null) {
            for (Enumerations.SensorName sensorName : sensorNames) {
                this.sensorIndex.add(new ReferenceIDs.SensorEntry(sensorName));
            }
        }
    }

    private ENOCEAN(String id, List<String> teachInNames, List<String> acknowledgeNames, IReferenceID superType) {
        this.id = id;
        this.superType = superType;
        if (this.superType != null) {
            this.superType.registerSubType(this);
        }
        this.teachInNames = teachInNames;
        this.acknowledgeNames = acknowledgeNames;
    }

    public String toString() {
        return this.id;
    }

    public static ENOCEAN getByReferenceId(String referenceId) {
        for (ENOCEAN value : ENOCEAN.values()) {
            if (!value.getReferenceId().equalsIgnoreCase(referenceId)) continue;
            return value;
        }
        return null;
    }

    @Override
    public void registerSubType(IReferenceID subType) {
        if (subType != null) {
            this.subTypes.add(subType);
        }
    }

    @Override
    public Set<IReferenceID> getSubTypes() {
        return Collections.unmodifiableSet(this.subTypes);
    }

    @Override
    public ISensor getMainSensor(ADevice device) {
        return device.getSensorByName(this.getSensorName(0));
    }

    @Override
    public String getSensorName(int index) {
        if (index >= this.sensorIndex.size()) {
            return null;
        }
        ReferenceIDs.SensorEntry entry = this.sensorIndex.get(index);
        return entry == null ? null : entry.getName();
    }

    @Override
    public ArrayList<ReferenceIDs.SensorEntry> getSensorIndex() {
        ArrayList<ReferenceIDs.SensorEntry> result = new ArrayList<ReferenceIDs.SensorEntry>();
        result.addAll(this.sensorIndex);
        return result;
    }

    @Override
    public String getReferenceId() {
        return this.id;
    }

    @Override
    public List<String> getTeachInNames() {
        List<String> result = null;
        if (this.teachInNames != null) {
            result = Collections.unmodifiableList(this.teachInNames);
        }
        return result;
    }

    @Override
    public List<String> getAcknowledgeNames() {
        List<String> result = null;
        if (this.acknowledgeNames != null) {
            result = Collections.unmodifiableList(this.acknowledgeNames);
        }
        return result;
    }

    @Override
    public IReferenceID getSuperType() {
        return this.superType;
    }
}

