/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.modules.parameter.model;

import bsc.api.modules.parameter.model.IModelParameter;
import java.util.Arrays;

public class Parameter
implements IModelParameter {
    private static final long serialVersionUID = 5084842515305988202L;
    public String name;
    public String section;
    public String value;
    public String measuringUnit;
    public String type;
    public String minValue;
    public String maxValue;
    public String stepSize;
    public String[] presets;

    public Parameter() {
    }

    public Parameter(String name) {
        this.name = name;
        this.type = Type.STRING.toString();
    }

    public Parameter(String name, String value) {
        this(name, value, null);
    }

    public Parameter(String name, String value, int maxValue) {
        this(name, value, (Integer)maxValue);
    }

    public Parameter(String name, String value, Integer maxValue) {
        this(name, value, maxValue, null);
    }

    public Parameter(String name, String value, Integer maxValue, String section) {
        this.name = name;
        this.type = Type.STRING.toString();
        this.value = value;
        this.maxValue = maxValue == null ? null : maxValue.toString();
        this.section = section;
    }

    public Parameter(String name, String[] presets) {
        this(name, presets, null);
    }

    public Parameter(String name, String[] presets, String value) {
        this(name, presets, value, null);
    }

    public Parameter(String name, String[] presets, String value, String section) {
        this.name = name;
        this.type = Type.PRESET.toString();
        this.presets = presets;
        this.value = value;
        this.section = section;
    }

    public Parameter(String name, double value) {
        this(name, (Double)value, null, null, null, null);
    }

    public Parameter(String name, double value, String measuringUnit) {
        this(name, (Double)value, measuringUnit, null, null, null);
    }

    public Parameter(String name, double value, String measuringUnit, double minValue, double maxValue) {
        this(name, (Double)value, measuringUnit, (Double)minValue, (Double)maxValue, null);
    }

    public Parameter(String name, double value, String measuringUnit, double minValue, double maxValue, double stepSize) {
        this(name, (Double)value, measuringUnit, (Double)minValue, (Double)maxValue, (Double)stepSize);
    }

    public Parameter(String name, Double value, String measuringUnit, Double minValue, Double maxValue, Double stepSize) {
        this(name, value, measuringUnit, minValue, maxValue, stepSize, null);
    }

    public Parameter(String name, Double value, String measuringUnit, Double minValue, Double maxValue, Double stepSize, String section) {
        this.name = name;
        this.type = Type.NUMBER.toString();
        this.value = value == null ? null : value.toString();
        this.measuringUnit = measuringUnit;
        this.minValue = minValue == null ? null : minValue.toString();
        this.maxValue = maxValue == null ? null : maxValue.toString();
        this.stepSize = stepSize == null ? null : stepSize.toString();
        this.section = section;
    }

    public Parameter(String name, Enum<?> value) {
        this.name = name;
        this.type = Type.PRESET.toString();
        this.value = value.toString();
        Enum[] values = (Enum[])value.getClass().getEnumConstants();
        this.presets = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.presets[i] = values[i].toString();
        }
    }

    public Parameter(String name, boolean value) {
        this.name = name;
        this.type = Type.BOOLEAN.toString();
        this.value = String.valueOf(value).toLowerCase();
    }

    public String toString() {
        return "Parameter [name=" + this.name + ", section=" + this.section + ", value=" + this.value + ", measuringUnit=" + this.measuringUnit + ", type=" + this.type + ", minValue=" + this.minValue + ", maxValue=" + this.maxValue + ", stepSize=" + this.stepSize + ", presets=" + Arrays.toString(this.presets) + "]";
    }

    public static enum Type {
        NUMBER,
        STRING,
        PRESET,
        BOOLEAN;

    }
}

